/*
 * Decompiled with CFR 0.152.
 */
package libs.io.undertow.attribute;

import libs.io.undertow.attribute.ExchangeAttribute;
import libs.io.undertow.attribute.ExchangeAttributeBuilder;
import libs.io.undertow.attribute.ReadOnlyAttributeException;
import libs.io.undertow.server.HttpServerExchange;

public class RequestSchemeAttribute
implements ExchangeAttribute {
    public static final String REQUEST_SCHEME = "%{SCHEME}";
    public static final ExchangeAttribute INSTANCE = new RequestSchemeAttribute();

    private RequestSchemeAttribute() {
    }

    @Override
    public String readAttribute(HttpServerExchange exchange) {
        return exchange.getRequestScheme();
    }

    @Override
    public void writeAttribute(HttpServerExchange exchange, String newValue) throws ReadOnlyAttributeException {
        exchange.setRequestScheme(newValue);
    }

    public String toString() {
        return REQUEST_SCHEME;
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Request scheme";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.equals(RequestSchemeAttribute.REQUEST_SCHEME)) {
                return INSTANCE;
            }
            return null;
        }

        @Override
        public int priority() {
            return 0;
        }
    }
}

