/*
 * Decompiled with CFR 0.152.
 */
package libs.io.undertow.attribute;

import libs.io.undertow.attribute.ExchangeAttribute;
import libs.io.undertow.attribute.ExchangeAttributeBuilder;
import libs.io.undertow.attribute.ReadOnlyAttributeException;
import libs.io.undertow.server.HttpServerExchange;

public class ResolvedPathAttribute
implements ExchangeAttribute {
    public static final String RESOLVED_PATH = "%{RESOLVED_PATH}";
    public static final ExchangeAttribute INSTANCE = new ResolvedPathAttribute();

    private ResolvedPathAttribute() {
    }

    @Override
    public String readAttribute(HttpServerExchange exchange) {
        return exchange.getResolvedPath();
    }

    @Override
    public void writeAttribute(HttpServerExchange exchange, String newValue) throws ReadOnlyAttributeException {
        exchange.setResolvedPath(newValue);
    }

    public String toString() {
        return RESOLVED_PATH;
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Resolved Path";
        }

        @Override
        public ExchangeAttribute build(String token) {
            return token.equals(ResolvedPathAttribute.RESOLVED_PATH) ? INSTANCE : null;
        }

        @Override
        public int priority() {
            return 0;
        }
    }
}

