/*
 * Decompiled with CFR 0.152.
 */
package libs.io.undertow.attribute;

import libs.io.undertow.attribute.ExchangeAttribute;
import libs.io.undertow.attribute.ExchangeAttributeBuilder;
import libs.io.undertow.attribute.ReadOnlyAttributeException;
import libs.io.undertow.server.HttpServerExchange;
import libs.io.undertow.util.HeaderValues;
import libs.io.undertow.util.HttpString;

public class ResponseHeaderAttribute
implements ExchangeAttribute {
    private final HttpString responseHeader;

    public ResponseHeaderAttribute(HttpString responseHeader) {
        this.responseHeader = responseHeader;
    }

    @Override
    public String readAttribute(HttpServerExchange exchange) {
        HeaderValues header = exchange.getResponseHeaders().get(this.responseHeader);
        if (header == null) {
            return null;
        }
        if (header.size() == 1) {
            return header.getFirst();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < header.size(); ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(header.get(i));
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void writeAttribute(HttpServerExchange exchange, String newValue) throws ReadOnlyAttributeException {
        exchange.getResponseHeaders().put(this.responseHeader, newValue);
    }

    public String toString() {
        return "%{o," + String.valueOf(this.responseHeader) + "}";
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Response header";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.startsWith("%{o,") && token.endsWith("}")) {
                HttpString headerName = HttpString.tryFromString(token.substring(4, token.length() - 1));
                return new ResponseHeaderAttribute(headerName);
            }
            return null;
        }

        @Override
        public int priority() {
            return 0;
        }
    }
}

