/*
 * Decompiled with CFR 0.152.
 */
package libs.io.undertow.attribute;

import libs.io.undertow.attribute.ExchangeAttribute;
import libs.io.undertow.attribute.ExchangeAttributeBuilder;
import libs.io.undertow.attribute.ReadOnlyAttributeException;
import libs.io.undertow.server.HttpServerExchange;
import libs.io.undertow.util.StatusCodes;

public class ResponseReasonPhraseAttribute
implements ExchangeAttribute {
    public static final String RESPONSE_REASON_PHRASE = "%{RESPONSE_REASON_PHRASE}";
    public static final ExchangeAttribute INSTANCE = new ResponseReasonPhraseAttribute();

    private ResponseReasonPhraseAttribute() {
    }

    @Override
    public String readAttribute(HttpServerExchange exchange) {
        return StatusCodes.getReason(exchange.getStatusCode());
    }

    @Override
    public void writeAttribute(HttpServerExchange exchange, String newValue) throws ReadOnlyAttributeException {
        exchange.setReasonPhrase(newValue);
    }

    public String toString() {
        return RESPONSE_REASON_PHRASE;
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Response reason phrase";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.equals(ResponseReasonPhraseAttribute.RESPONSE_REASON_PHRASE)) {
                return INSTANCE;
            }
            return null;
        }

        @Override
        public int priority() {
            return 0;
        }
    }
}

