/*
 * Decompiled with CFR 0.152.
 */
package libs.io.undertow.conduits;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import libs.io.undertow.conduits.ByteActivityCallback;
import libs.org.xnio.channels.StreamSinkChannel;
import libs.org.xnio.conduits.AbstractStreamSourceConduit;
import libs.org.xnio.conduits.StreamSourceConduit;

public class BytesReceivedStreamSourceConduit
extends AbstractStreamSourceConduit<StreamSourceConduit> {
    private final ByteActivityCallback callback;

    public BytesReceivedStreamSourceConduit(StreamSourceConduit next, ByteActivityCallback callback) {
        super(next);
        this.callback = callback;
    }

    @Override
    public long transferTo(long position, long count, FileChannel target) throws IOException {
        long l = super.transferTo(position, count, target);
        if (l > 0L) {
            this.callback.activity(l);
        }
        return l;
    }

    @Override
    public long transferTo(long count, ByteBuffer throughBuffer, StreamSinkChannel target) throws IOException {
        long l = super.transferTo(count, throughBuffer, target);
        if (l > 0L) {
            this.callback.activity(l);
        }
        return l;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int i = super.read(dst);
        if (i > 0) {
            this.callback.activity(i);
        }
        return i;
    }

    @Override
    public long read(ByteBuffer[] dsts, int offs, int len) throws IOException {
        long l = super.read(dsts, offs, len);
        if (l > 0L) {
            this.callback.activity(l);
        }
        return l;
    }
}

