/*
 * Decompiled with CFR 0.152.
 */
package libs.io.undertow.conduits;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import libs.io.undertow.UndertowMessages;
import libs.io.undertow.server.HttpServerExchange;
import libs.io.undertow.util.AttachmentKey;
import libs.org.xnio.IoUtils;
import libs.org.xnio.channels.StreamSourceChannel;
import libs.org.xnio.conduits.AbstractStreamSinkConduit;
import libs.org.xnio.conduits.ConduitWritableByteChannel;
import libs.org.xnio.conduits.StreamSinkConduit;

public final class StoredResponseStreamSinkConduit
extends AbstractStreamSinkConduit<StreamSinkConduit> {
    public static final AttachmentKey<byte[]> RESPONSE = AttachmentKey.create(byte[].class);
    private ByteArrayOutputStream outputStream;
    private final HttpServerExchange exchange;

    public StoredResponseStreamSinkConduit(StreamSinkConduit next, HttpServerExchange exchange) {
        super(next);
        this.exchange = exchange;
        long length = exchange.getResponseContentLength();
        if (length <= 0L) {
            this.outputStream = new ByteArrayOutputStream();
        } else {
            if (length > Integer.MAX_VALUE) {
                throw UndertowMessages.MESSAGES.responseTooLargeToBuffer(length);
            }
            this.outputStream = new ByteArrayOutputStream((int)length);
        }
    }

    @Override
    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        return IoUtils.transfer(source, count, throughBuffer, new ConduitWritableByteChannel(this));
    }

    @Override
    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        return src.transferTo(position, count, new ConduitWritableByteChannel(this));
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        int start = src.position();
        int ret = super.write(src);
        if (this.outputStream != null) {
            for (int i = start; i < start + ret; ++i) {
                this.outputStream.write(src.get(i));
            }
        }
        return ret;
    }

    @Override
    public long write(ByteBuffer[] srcs, int offs, int len) throws IOException {
        long ret;
        int[] starts = new int[len];
        for (int i = 0; i < len; ++i) {
            starts[i] = srcs[i + offs].position();
        }
        long rem = ret = super.write(srcs, offs, len);
        if (this.outputStream != null) {
            for (int i = 0; i < len; ++i) {
                ByteBuffer buf = srcs[i + offs];
                for (int pos = starts[i]; rem > 0L && pos < buf.position(); ++pos, --rem) {
                    this.outputStream.write(buf.get(pos));
                }
            }
        }
        return ret;
    }

    @Override
    public int writeFinal(ByteBuffer src) throws IOException {
        int start = src.position();
        int ret = super.writeFinal(src);
        if (this.outputStream != null) {
            for (int i = start; i < start + ret; ++i) {
                this.outputStream.write(src.get(i));
            }
            if (!src.hasRemaining()) {
                this.exchange.putAttachment(RESPONSE, this.outputStream.toByteArray());
                this.outputStream = null;
            }
        }
        return ret;
    }

    @Override
    public long writeFinal(ByteBuffer[] srcs, int offs, int len) throws IOException {
        long ret;
        int[] starts = new int[len];
        long toWrite = 0L;
        for (int i = 0; i < len; ++i) {
            starts[i] = srcs[i + offs].position();
            toWrite += (long)srcs[i + offs].remaining();
        }
        long rem = ret = super.write(srcs, offs, len);
        if (this.outputStream != null) {
            for (int i = 0; i < len; ++i) {
                ByteBuffer buf = srcs[i + offs];
                for (int pos = starts[i]; rem > 0L && pos < buf.position(); ++pos, --rem) {
                    this.outputStream.write(buf.get(pos));
                }
            }
            if (toWrite == ret) {
                this.exchange.putAttachment(RESPONSE, this.outputStream.toByteArray());
                this.outputStream = null;
            }
        }
        return ret;
    }

    @Override
    public void terminateWrites() throws IOException {
        if (this.outputStream != null) {
            this.exchange.putAttachment(RESPONSE, this.outputStream.toByteArray());
            this.outputStream = null;
        }
        super.terminateWrites();
    }
}

