/*
 * Decompiled with CFR 0.152.
 */
package libs.io.undertow.predicate;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import libs.io.undertow.predicate.Predicate;
import libs.io.undertow.predicate.PredicateBuilder;
import libs.io.undertow.security.api.SecurityContext;
import libs.io.undertow.server.HttpServerExchange;

public class AuthenticationRequiredPredicate
implements Predicate {
    public static final AuthenticationRequiredPredicate INSTANCE = new AuthenticationRequiredPredicate();

    @Override
    public boolean resolve(HttpServerExchange value) {
        SecurityContext sc = value.getSecurityContext();
        if (sc == null) {
            return false;
        }
        return sc.isAuthenticationRequired();
    }

    public String toString() {
        return "auth-required()";
    }

    public static class Builder
    implements PredicateBuilder {
        @Override
        public String name() {
            return "auth-required";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            HashMap params = new HashMap();
            return params;
        }

        @Override
        public Set<String> requiredParameters() {
            HashSet<String> params = new HashSet<String>();
            return params;
        }

        @Override
        public String defaultParameter() {
            return null;
        }

        @Override
        public Predicate build(Map<String, Object> config) {
            return INSTANCE;
        }
    }
}

