/*
 * Decompiled with CFR 0.152.
 */
package libs.io.undertow.protocols.ajp;

import java.nio.ByteBuffer;
import libs.io.undertow.util.HttpString;

class AjpUtils {
    AjpUtils() {
    }

    static boolean notNull(Boolean attachment) {
        return attachment == null ? false : attachment;
    }

    static int notNull(Integer attachment) {
        return attachment == null ? 0 : attachment;
    }

    static String notNull(String attachment) {
        return attachment == null ? "" : attachment;
    }

    static void putInt(ByteBuffer buf, int value) {
        buf.put((byte)(value >> 8 & 0xFF));
        buf.put((byte)(value & 0xFF));
    }

    static void putString(ByteBuffer buf, String value) {
        int length = value.length();
        AjpUtils.putInt(buf, length);
        for (int i = 0; i < length; ++i) {
            buf.put((byte)value.charAt(i));
        }
        buf.put((byte)0);
    }

    static void putHttpString(ByteBuffer buf, HttpString value) {
        int length = value.length();
        AjpUtils.putInt(buf, length);
        value.appendTo(buf);
        buf.put((byte)0);
    }
}

