/*
 * Decompiled with CFR 0.152.
 */
package libs.io.undertow.protocols.http2;

import java.io.IOException;
import java.nio.ByteBuffer;
import libs.io.undertow.UndertowMessages;
import libs.io.undertow.protocols.http2.Http2FrameHeaderParser;

public abstract class Http2PushBackParser {
    private byte[] pushedBackData;
    private boolean finished;
    private int remainingData;
    private final int frameLength;
    int cnt;

    public Http2PushBackParser(int frameLength) {
        this.remainingData = frameLength;
        this.frameLength = frameLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(ByteBuffer data, Http2FrameHeaderParser headerParser) throws IOException {
        int used = 0;
        ByteBuffer dataToParse = data;
        int oldLimit = data.limit();
        Throwable original = null;
        try {
            if (this.pushedBackData != null) {
                int toCopy = Math.min(this.remainingData - this.pushedBackData.length, data.remaining());
                dataToParse = ByteBuffer.wrap(new byte[this.pushedBackData.length + toCopy]);
                dataToParse.put(this.pushedBackData);
                data.limit(data.position() + toCopy);
                dataToParse.put(data);
                dataToParse.flip();
            }
            if (dataToParse.remaining() > this.remainingData) {
                dataToParse.limit(dataToParse.position() + this.remainingData);
            }
            int rem = dataToParse.remaining();
            this.handleData(dataToParse, headerParser);
            used = rem - dataToParse.remaining();
            if (!this.isFinished() && this.remainingData > 0 && used == 0 && dataToParse.remaining() >= this.remainingData && this.cnt++ == 100) {
                original = UndertowMessages.MESSAGES.parserDidNotMakeProgress();
            }
        }
        catch (Throwable t) {
            original = t;
        }
        finally {
            try {
                if (this.finished) {
                    data.limit(oldLimit);
                } else {
                    int leftOver = dataToParse.remaining();
                    if (leftOver > 0) {
                        this.pushedBackData = new byte[leftOver];
                        dataToParse.get(this.pushedBackData);
                    } else {
                        this.pushedBackData = null;
                    }
                    data.limit(oldLimit);
                    this.remainingData -= used;
                    if (this.remainingData == 0) {
                        this.finished = true;
                    }
                }
            }
            catch (Throwable t) {
                if (original != null) {
                    original.addSuppressed(t);
                }
                original = t;
            }
            if (original != null) {
                if (original instanceof RuntimeException) {
                    throw (RuntimeException)original;
                }
                if (original instanceof Error) {
                    throw (Error)original;
                }
                if (original instanceof IOException) {
                    throw (IOException)original;
                }
            }
        }
    }

    protected abstract void handleData(ByteBuffer var1, Http2FrameHeaderParser var2) throws IOException;

    public boolean isFinished() {
        if (this.pushedBackData != null && this.remainingData == this.pushedBackData.length) {
            return true;
        }
        return this.finished;
    }

    protected void finish() {
        this.finished = true;
    }

    protected boolean moreData(int data) {
        this.finished = false;
        this.remainingData += data;
        return true;
    }

    public int getFrameLength() {
        return this.frameLength;
    }
}

