/*
 * Decompiled with CFR 0.152.
 */
package libs.io.undertow.security.handlers;

import libs.io.undertow.UndertowLogger;
import libs.io.undertow.security.api.SecurityContext;
import libs.io.undertow.server.HttpHandler;
import libs.io.undertow.server.HttpServerExchange;

public class AuthenticationConstraintHandler
implements HttpHandler {
    private final HttpHandler next;

    public AuthenticationConstraintHandler(HttpHandler next) {
        this.next = next;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (this.isAuthenticationRequired(exchange)) {
            SecurityContext context = exchange.getSecurityContext();
            UndertowLogger.SECURITY_LOGGER.debugf("Setting authentication required for exchange %s", (Object)exchange);
            context.setAuthenticationRequired();
        }
        this.next.handleRequest(exchange);
    }

    protected boolean isAuthenticationRequired(HttpServerExchange exchange) {
        return true;
    }
}

