/*
 * Decompiled with CFR 0.152.
 */
package libs.io.undertow.security.handlers;

import libs.io.undertow.security.api.AuthenticationMode;
import libs.io.undertow.security.api.SecurityContext;
import libs.io.undertow.security.api.SecurityContextFactory;
import libs.io.undertow.security.handlers.AbstractSecurityContextAssociationHandler;
import libs.io.undertow.security.idm.IdentityManager;
import libs.io.undertow.security.impl.SecurityContextFactoryImpl;
import libs.io.undertow.server.HttpHandler;
import libs.io.undertow.server.HttpServerExchange;

public class SecurityInitialHandler
extends AbstractSecurityContextAssociationHandler {
    private final AuthenticationMode authenticationMode;
    private final IdentityManager identityManager;
    private final String programaticMechName;
    private final SecurityContextFactory contextFactory;

    public SecurityInitialHandler(AuthenticationMode authenticationMode, IdentityManager identityManager, String programaticMechName, SecurityContextFactory contextFactory, HttpHandler next) {
        super(next);
        this.authenticationMode = authenticationMode;
        this.identityManager = identityManager;
        this.programaticMechName = programaticMechName;
        this.contextFactory = contextFactory;
    }

    public SecurityInitialHandler(AuthenticationMode authenticationMode, IdentityManager identityManager, String programaticMechName, HttpHandler next) {
        this(authenticationMode, identityManager, programaticMechName, SecurityContextFactoryImpl.INSTANCE, next);
    }

    public SecurityInitialHandler(AuthenticationMode authenticationMode, IdentityManager identityManager, HttpHandler next) {
        this(authenticationMode, identityManager, null, SecurityContextFactoryImpl.INSTANCE, next);
    }

    @Override
    public SecurityContext createSecurityContext(HttpServerExchange exchange) {
        return this.contextFactory.createSecurityContext(exchange, this.authenticationMode, this.identityManager, this.programaticMechName);
    }
}

