/*
 * Decompiled with CFR 0.152.
 */
package libs.io.undertow.security.impl;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import libs.io.undertow.util.HeaderToken;
import libs.io.undertow.util.HeaderTokenParser;
import libs.io.undertow.util.Headers;
import libs.io.undertow.util.HttpString;

public enum DigestWWWAuthenticateToken implements HeaderToken
{
    REALM(Headers.REALM, true),
    DOMAIN(Headers.DOMAIN, true),
    NONCE(Headers.NONCE, true),
    OPAQUE(Headers.OPAQUE, true),
    STALE(Headers.STALE, false),
    ALGORITHM(Headers.ALGORITHM, false),
    MESSAGE_QOP(Headers.QOP, true),
    AUTH_PARAM(Headers.AUTH_PARAM, false);

    private static final HeaderTokenParser<DigestWWWAuthenticateToken> TOKEN_PARSER;
    private final String name;
    private final boolean quoted;

    private DigestWWWAuthenticateToken(HttpString name, boolean quoted) {
        this.name = name.toString();
        this.quoted = quoted;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isAllowQuoted() {
        return this.quoted;
    }

    public static Map<DigestWWWAuthenticateToken, String> parseHeader(String header) {
        return TOKEN_PARSER.parseHeader(header);
    }

    static {
        LinkedHashMap<String, DigestWWWAuthenticateToken> expected = new LinkedHashMap<String, DigestWWWAuthenticateToken>(DigestWWWAuthenticateToken.values().length);
        for (DigestWWWAuthenticateToken current : DigestWWWAuthenticateToken.values()) {
            expected.put(current.getName(), current);
        }
        TOKEN_PARSER = new HeaderTokenParser(Collections.unmodifiableMap(expected));
    }
}

