/*
 * Decompiled with CFR 0.152.
 */
package libs.io.undertow.security.impl;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import libs.io.undertow.security.idm.Account;
import libs.io.undertow.security.impl.SingleSignOn;
import libs.io.undertow.security.impl.SingleSignOnManager;
import libs.io.undertow.server.session.SecureRandomSessionIdGenerator;
import libs.io.undertow.server.session.Session;
import libs.io.undertow.server.session.SessionManager;
import libs.io.undertow.util.CopyOnWriteMap;
import libs.org.jboss.logging.Logger;

public class InMemorySingleSignOnManager
implements SingleSignOnManager {
    private static final Logger log = Logger.getLogger(InMemorySingleSignOnManager.class);
    private static final SecureRandomSessionIdGenerator SECURE_RANDOM_SESSION_ID_GENERATOR = new SecureRandomSessionIdGenerator();
    private final Map<String, SingleSignOn> ssoEntries = new ConcurrentHashMap<String, SingleSignOn>();

    @Override
    public SingleSignOn findSingleSignOn(String ssoId) {
        return this.ssoEntries.get(ssoId);
    }

    @Override
    public SingleSignOn createSingleSignOn(Account account, String mechanism) {
        String id = SECURE_RANDOM_SESSION_ID_GENERATOR.createSessionId();
        SimpleSingleSignOnEntry entry = new SimpleSingleSignOnEntry(id, account, mechanism);
        this.ssoEntries.put(id, entry);
        if (log.isTraceEnabled()) {
            log.tracef("Creating SSO ID %s for Principal %s and Roles %s.", (Object)id, (Object)account.getPrincipal().getName(), (Object)account.getRoles().toString());
        }
        return entry;
    }

    @Override
    public void removeSingleSignOn(SingleSignOn sso) {
        if (log.isTraceEnabled()) {
            log.tracef("Removing SSO ID %s.", (Object)sso.getId());
        }
        this.ssoEntries.remove(sso.getId());
    }

    private static class SimpleSingleSignOnEntry
    implements SingleSignOn {
        private final String id;
        private final Account account;
        private final String mechanismName;
        private final Map<SessionManager, Session> sessions = new CopyOnWriteMap<SessionManager, Session>();

        SimpleSingleSignOnEntry(String id, Account account, String mechanismName) {
            this.id = id;
            this.account = account;
            this.mechanismName = mechanismName;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public Account getAccount() {
            return this.account;
        }

        @Override
        public String getMechanismName() {
            return this.mechanismName;
        }

        @Override
        public Iterator<Session> iterator() {
            return Collections.unmodifiableCollection(this.sessions.values()).iterator();
        }

        @Override
        public boolean contains(Session session) {
            return this.sessions.containsKey(session.getSessionManager());
        }

        @Override
        public Session getSession(SessionManager manager) {
            return this.sessions.get(manager);
        }

        @Override
        public void add(Session session) {
            this.sessions.put(session.getSessionManager(), session);
        }

        @Override
        public void remove(Session session) {
            this.sessions.remove(session.getSessionManager());
        }

        @Override
        public void close() {
        }
    }
}

