/*
 * Decompiled with CFR 0.152.
 */
package libs.io.undertow.security.impl;

import java.util.Collections;
import java.util.LinkedList;
import java.util.Set;
import java.util.WeakHashMap;
import libs.io.undertow.UndertowLogger;
import libs.io.undertow.security.api.AuthenticationMechanism;
import libs.io.undertow.security.api.NotificationReceiver;
import libs.io.undertow.security.api.SecurityContext;
import libs.io.undertow.security.api.SecurityNotification;
import libs.io.undertow.security.idm.Account;
import libs.io.undertow.security.idm.IdentityManager;
import libs.io.undertow.security.impl.SingleSignOn;
import libs.io.undertow.security.impl.SingleSignOnManager;
import libs.io.undertow.server.ConduitWrapper;
import libs.io.undertow.server.HttpServerExchange;
import libs.io.undertow.server.handlers.Cookie;
import libs.io.undertow.server.handlers.CookieImpl;
import libs.io.undertow.server.session.Session;
import libs.io.undertow.server.session.SessionListener;
import libs.io.undertow.server.session.SessionManager;
import libs.io.undertow.util.ConduitFactory;
import libs.io.undertow.util.Sessions;
import libs.org.jboss.logging.Logger;
import libs.org.xnio.conduits.StreamSinkConduit;

public class SingleSignOnAuthenticationMechanism
implements AuthenticationMechanism {
    private static final Logger log = Logger.getLogger(SingleSignOnAuthenticationMechanism.class);
    private static final String SSO_SESSION_ATTRIBUTE = SingleSignOnAuthenticationMechanism.class.getName() + ".SSOID";
    private final Set<SessionManager> seenSessionManagers = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));
    private String cookieName = "JSESSIONIDSSO";
    private boolean httpOnly;
    private boolean secure;
    private String domain;
    private String path;
    private final SessionInvalidationListener listener = new SessionInvalidationListener();
    private final ResponseListener responseListener = new ResponseListener();
    private final SingleSignOnManager singleSignOnManager;
    private final IdentityManager identityManager;

    public SingleSignOnAuthenticationMechanism(SingleSignOnManager storage) {
        this(storage, null);
    }

    public SingleSignOnAuthenticationMechanism(SingleSignOnManager storage, IdentityManager identityManager) {
        this.singleSignOnManager = storage;
        this.identityManager = identityManager;
    }

    private IdentityManager getIdentityManager(SecurityContext securityContext) {
        return this.identityManager != null ? this.identityManager : securityContext.getIdentityManager();
    }

    @Override
    public AuthenticationMechanism.AuthenticationMechanismOutcome authenticate(HttpServerExchange exchange, SecurityContext securityContext) {
        Cookie cookie = null;
        for (Cookie c : exchange.requestCookies()) {
            if (!this.cookieName.equals(c.getName())) continue;
            cookie = c;
        }
        if (cookie != null) {
            String ssoId = cookie.getValue();
            log.tracef("Found SSO cookie %s", (Object)ssoId);
            try (final SingleSignOn sso = this.singleSignOnManager.findSingleSignOn(ssoId);){
                if (sso != null) {
                    Account verified;
                    if (log.isTraceEnabled()) {
                        log.tracef("SSO session with ID: %s found.", (Object)ssoId);
                    }
                    if ((verified = this.getIdentityManager(securityContext).verify(sso.getAccount())) == null) {
                        if (log.isTraceEnabled()) {
                            log.tracef("Account not found. Returning 'not attempted' here.", new Object[0]);
                        }
                        AuthenticationMechanism.AuthenticationMechanismOutcome authenticationMechanismOutcome = AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_ATTEMPTED;
                        return authenticationMechanismOutcome;
                    }
                    Session session = this.getSession(exchange);
                    this.registerSessionIfRequired(sso, session);
                    securityContext.authenticationComplete(verified, sso.getMechanismName(), false);
                    securityContext.registerNotificationReceiver(new NotificationReceiver(){

                        @Override
                        public void handleNotification(SecurityNotification notification) {
                            if (notification.getEventType() == SecurityNotification.EventType.LOGGED_OUT) {
                                SingleSignOnAuthenticationMechanism.this.singleSignOnManager.removeSingleSignOn(sso);
                            }
                        }
                    });
                    log.tracef("Authenticated account %s using SSO", (Object)verified.getPrincipal().getName());
                    AuthenticationMechanism.AuthenticationMechanismOutcome authenticationMechanismOutcome = AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED;
                    return authenticationMechanismOutcome;
                }
            }
            this.clearSsoCookie(exchange);
        }
        exchange.addResponseWrapper(this.responseListener);
        return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_ATTEMPTED;
    }

    private void registerSessionIfRequired(SingleSignOn sso, Session session) {
        SessionManager manager;
        if (!sso.contains(session)) {
            if (log.isTraceEnabled()) {
                log.tracef("Session %s added to SSO %s", (Object)session.getId(), (Object)sso.getId());
            }
            sso.add(session);
        }
        if (session.getAttribute(SSO_SESSION_ATTRIBUTE) == null) {
            if (log.isTraceEnabled()) {
                log.tracef("SSO_SESSION_ATTRIBUTE not found. Creating it with SSO ID %s as value.", (Object)sso.getId());
            }
            session.setAttribute(SSO_SESSION_ATTRIBUTE, sso.getId());
        }
        if (this.seenSessionManagers.add(manager = session.getSessionManager())) {
            manager.registerSessionListener(this.listener);
        }
    }

    private void clearSsoCookie(HttpServerExchange exchange) {
        exchange.setResponseCookie(new CookieImpl(this.cookieName).setMaxAge(0).setHttpOnly(this.httpOnly).setSecure(this.secure).setDomain(this.domain).setPath(this.path));
    }

    @Override
    public AuthenticationMechanism.ChallengeResult sendChallenge(HttpServerExchange exchange, SecurityContext securityContext) {
        return AuthenticationMechanism.ChallengeResult.NOT_SENT;
    }

    protected Session getSession(HttpServerExchange exchange) {
        return Sessions.getOrCreateSession(exchange);
    }

    public String getCookieName() {
        return this.cookieName;
    }

    public SingleSignOnAuthenticationMechanism setCookieName(String cookieName) {
        this.cookieName = cookieName;
        return this;
    }

    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    public SingleSignOnAuthenticationMechanism setHttpOnly(boolean httpOnly) {
        this.httpOnly = httpOnly;
        return this;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public SingleSignOnAuthenticationMechanism setSecure(boolean secure) {
        this.secure = secure;
        return this;
    }

    public String getDomain() {
        return this.domain;
    }

    public SingleSignOnAuthenticationMechanism setDomain(String domain) {
        this.domain = domain;
        return this;
    }

    public String getPath() {
        return this.path;
    }

    public SingleSignOnAuthenticationMechanism setPath(String path) {
        this.path = path;
        return this;
    }

    final class SessionInvalidationListener
    implements SessionListener {
        SessionInvalidationListener() {
        }

        @Override
        public void sessionCreated(Session session, HttpServerExchange exchange) {
        }

        @Override
        public void sessionDestroyed(Session session, HttpServerExchange exchange, SessionListener.SessionDestroyedReason reason) {
            String ssoId = (String)session.getAttribute(SSO_SESSION_ATTRIBUTE);
            if (ssoId != null) {
                if (log.isTraceEnabled()) {
                    log.tracef("Removing SSO ID %s from destroyed session %s.", (Object)ssoId, (Object)session.getId());
                }
                LinkedList<Session> sessionsToRemove = new LinkedList<Session>();
                try (SingleSignOn sso = SingleSignOnAuthenticationMechanism.this.singleSignOnManager.findSingleSignOn(ssoId);){
                    if (sso != null) {
                        sso.remove(session);
                        if (reason == SessionListener.SessionDestroyedReason.INVALIDATED) {
                            for (Session associatedSession : sso) {
                                sso.remove(associatedSession);
                                sessionsToRemove.add(associatedSession);
                            }
                        }
                        if (!sso.iterator().hasNext()) {
                            SingleSignOnAuthenticationMechanism.this.singleSignOnManager.removeSingleSignOn(sso);
                        }
                    }
                }
                for (Session sessionToRemove : sessionsToRemove) {
                    sessionToRemove.invalidate(null);
                }
            }
        }

        @Override
        public void attributeAdded(Session session, String name, Object value) {
        }

        @Override
        public void attributeUpdated(Session session, String name, Object newValue, Object oldValue) {
        }

        @Override
        public void attributeRemoved(Session session, String name, Object oldValue) {
        }

        @Override
        public void sessionIdChanged(Session session, String oldSessionId) {
        }
    }

    final class ResponseListener
    implements ConduitWrapper<StreamSinkConduit> {
        ResponseListener() {
        }

        @Override
        public StreamSinkConduit wrap(ConduitFactory<StreamSinkConduit> factory, HttpServerExchange exchange) {
            SecurityContext sc = exchange.getSecurityContext();
            Account account = sc.getAuthenticatedAccount();
            if (account != null) {
                try (SingleSignOn sso = SingleSignOnAuthenticationMechanism.this.singleSignOnManager.createSingleSignOn(account, sc.getMechanismName());){
                    Session session = SingleSignOnAuthenticationMechanism.this.getSession(exchange);
                    if (sso != null) {
                        SingleSignOnAuthenticationMechanism.this.registerSessionIfRequired(sso, session);
                        exchange.setResponseCookie(new CookieImpl(SingleSignOnAuthenticationMechanism.this.cookieName, sso.getId()).setHttpOnly(SingleSignOnAuthenticationMechanism.this.httpOnly).setSecure(SingleSignOnAuthenticationMechanism.this.secure).setDomain(SingleSignOnAuthenticationMechanism.this.domain).setPath(SingleSignOnAuthenticationMechanism.this.path));
                    } else {
                        UndertowLogger.SECURITY_LOGGER.failedToCreateSSOForSession(SSO_SESSION_ATTRIBUTE);
                    }
                }
            }
            return factory.create();
        }
    }
}

