/*
 * Decompiled with CFR 0.152.
 */
package libs.io.undertow.server;

import libs.io.undertow.server.ConnectorStatistics;

public class AggregateConnectorStatistics
implements ConnectorStatistics {
    private final ConnectorStatistics[] connectorStatistics;

    public AggregateConnectorStatistics(ConnectorStatistics[] connectorStatistics) {
        this.connectorStatistics = connectorStatistics;
    }

    @Override
    public long getRequestCount() {
        long count = 0L;
        for (ConnectorStatistics c : this.connectorStatistics) {
            count += c.getRequestCount();
        }
        return count;
    }

    @Override
    public long getBytesSent() {
        long count = 0L;
        for (ConnectorStatistics c : this.connectorStatistics) {
            count += c.getBytesSent();
        }
        return count;
    }

    @Override
    public long getBytesReceived() {
        long count = 0L;
        for (ConnectorStatistics c : this.connectorStatistics) {
            count += c.getBytesReceived();
        }
        return count;
    }

    @Override
    public long getErrorCount() {
        long count = 0L;
        for (ConnectorStatistics c : this.connectorStatistics) {
            count += c.getErrorCount();
        }
        return count;
    }

    @Override
    public long getProcessingTime() {
        long count = 0L;
        for (ConnectorStatistics c : this.connectorStatistics) {
            count += c.getProcessingTime();
        }
        return count;
    }

    @Override
    public long getMaxProcessingTime() {
        long max = 0L;
        for (ConnectorStatistics c : this.connectorStatistics) {
            max = Math.max(c.getMaxProcessingTime(), max);
        }
        return max;
    }

    @Override
    public void reset() {
        for (ConnectorStatistics c : this.connectorStatistics) {
            c.reset();
        }
    }

    @Override
    public long getActiveConnections() {
        long count = 0L;
        for (ConnectorStatistics c : this.connectorStatistics) {
            count += c.getActiveConnections();
        }
        return count;
    }

    @Override
    public long getMaxActiveConnections() {
        long count = 0L;
        for (ConnectorStatistics c : this.connectorStatistics) {
            count += c.getMaxActiveConnections();
        }
        return count;
    }

    @Override
    public long getActiveRequests() {
        long count = 0L;
        for (ConnectorStatistics c : this.connectorStatistics) {
            count += c.getActiveRequests();
        }
        return count;
    }

    @Override
    public long getMaxActiveRequests() {
        long count = 0L;
        for (ConnectorStatistics c : this.connectorStatistics) {
            count += c.getMaxActiveRequests();
        }
        return count;
    }
}

