/*
 * Decompiled with CFR 0.152.
 */
package libs.io.undertow.server;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.LinkedList;
import java.util.Queue;
import libs.io.undertow.UndertowLogger;
import sun.misc.Unsafe;

public final class DirectByteBufferDeallocator {
    private static final int DEALLOCATION_DELAY_MILLIS = 100;
    private static final boolean SUPPORTED;
    private static final Method cleaner;
    private static final Method cleanerClean;
    private static final ThreadLocal<Queue<QueuedByteBuffer>> bufferQueue;
    private static final Unsafe UNSAFE;

    private DirectByteBufferDeallocator() {
    }

    public static void free(ByteBuffer buffer) {
        if (SUPPORTED && buffer != null && buffer.isDirect()) {
            try {
                Queue<QueuedByteBuffer> queuedByteBuffers = bufferQueue.get();
                long targetTimeMillis = System.currentTimeMillis() - 100L;
                QueuedByteBuffer queuedByteBuffer = queuedByteBuffers.peek();
                while (queuedByteBuffer != null && queuedByteBuffer.timeStamp <= targetTimeMillis) {
                    queuedByteBuffers.remove();
                    DirectByteBufferDeallocator.cleanBuffer(queuedByteBuffer.byteBuffer);
                    queuedByteBuffer = queuedByteBuffers.peek();
                }
                queuedByteBuffers.add(new QueuedByteBuffer(buffer));
            }
            catch (Throwable t) {
                UndertowLogger.ROOT_LOGGER.directBufferDeallocationFailed(t);
            }
        }
    }

    private static void cleanBuffer(ByteBuffer buffer) throws InvocationTargetException, IllegalAccessException {
        if (buffer != null) {
            if (UNSAFE != null) {
                cleanerClean.invoke((Object)UNSAFE, buffer);
            } else {
                Object cleaner = DirectByteBufferDeallocator.cleaner.invoke((Object)buffer, new Object[0]);
                cleanerClean.invoke(cleaner, new Object[0]);
            }
        }
    }

    private static Unsafe getUnsafe() {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(new PrivilegedAction<Unsafe>(){

                @Override
                public Unsafe run() {
                    return DirectByteBufferDeallocator.getUnsafe0();
                }
            });
        }
        return DirectByteBufferDeallocator.getUnsafe0();
    }

    private static Unsafe getUnsafe0() {
        try {
            Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            return (Unsafe)theUnsafe.get(null);
        }
        catch (Throwable t) {
            throw new RuntimeException("JDK did not allow accessing unsafe", t);
        }
    }

    private static Method getAccesibleMethod(final String className, final String methodName) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(new PrivilegedAction<Method>(){

                @Override
                public Method run() {
                    return DirectByteBufferDeallocator.getAccesibleMethod0(className, methodName);
                }
            });
        }
        return DirectByteBufferDeallocator.getAccesibleMethod0(className, methodName);
    }

    private static Method getAccesibleMethod0(String className, String methodName) {
        try {
            Method method = Class.forName(className).getMethod(methodName, new Class[0]);
            method.setAccessible(true);
            return method;
        }
        catch (Throwable t) {
            throw new RuntimeException("JDK did not allow accessing method", t);
        }
    }

    private static Method getDeclaredMethod(final Unsafe tmpUnsafe, final String methodName, final Class<?> ... parameterTypes) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(new PrivilegedAction<Method>(){

                @Override
                public Method run() {
                    return DirectByteBufferDeallocator.getDeclaredMethod0(tmpUnsafe, methodName, parameterTypes);
                }
            });
        }
        return DirectByteBufferDeallocator.getDeclaredMethod0(tmpUnsafe, methodName, parameterTypes);
    }

    private static Method getDeclaredMethod0(Unsafe tmpUnsafe, String methodName, Class<?> ... parameterTypes) {
        try {
            Method method = tmpUnsafe.getClass().getDeclaredMethod(methodName, parameterTypes);
            method.setAccessible(true);
            return method;
        }
        catch (Throwable t) {
            throw new RuntimeException("JDK did not allow accessing method", t);
        }
    }

    static {
        boolean supported;
        bufferQueue = ThreadLocal.withInitial(() -> new LinkedList());
        String versionString = System.getProperty("java.specification.version");
        if (versionString.equals("0.9")) {
            versionString = "11";
        } else if (versionString.startsWith("1.")) {
            versionString = versionString.substring(2);
        }
        int version = Integer.parseInt(versionString);
        Method tmpCleaner = null;
        Method tmpCleanerClean = null;
        Unsafe tmpUnsafe = null;
        if (version < 9) {
            try {
                tmpCleaner = DirectByteBufferDeallocator.getAccesibleMethod("java.nio.DirectByteBuffer", "cleaner");
                tmpCleanerClean = DirectByteBufferDeallocator.getAccesibleMethod("sun.misc.Cleaner", "clean");
                supported = true;
            }
            catch (Throwable t) {
                UndertowLogger.ROOT_LOGGER.directBufferDeallocatorInitializationFailed(t);
                supported = false;
            }
        } else {
            try {
                tmpUnsafe = DirectByteBufferDeallocator.getUnsafe();
                tmpCleanerClean = DirectByteBufferDeallocator.getDeclaredMethod(tmpUnsafe, "invokeCleaner", ByteBuffer.class);
                supported = true;
            }
            catch (Throwable t) {
                UndertowLogger.ROOT_LOGGER.directBufferDeallocatorInitializationFailed(t);
                supported = false;
            }
        }
        SUPPORTED = supported;
        cleaner = tmpCleaner;
        cleanerClean = tmpCleanerClean;
        UNSAFE = tmpUnsafe;
    }

    private static class QueuedByteBuffer {
        final long timeStamp = System.currentTimeMillis();
        final ByteBuffer byteBuffer;

        QueuedByteBuffer(ByteBuffer byteBuffer) {
            this.byteBuffer = byteBuffer;
        }
    }
}

