/*
 * Decompiled with CFR 0.152.
 */
package libs.io.undertow.server.handlers;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import libs.io.undertow.server.HttpHandler;
import libs.io.undertow.server.HttpServerExchange;
import libs.io.undertow.server.handlers.ResponseCodeHandler;
import libs.io.undertow.util.AttachmentKey;
import libs.io.undertow.util.PathTemplate;
import libs.io.undertow.util.PathTemplateMatcher;

public class PathTemplateHandler
implements HttpHandler {
    private final boolean rewriteQueryParameters;
    private final HttpHandler next;
    @Deprecated
    public static final AttachmentKey<PathTemplateMatch> PATH_TEMPLATE_MATCH = AttachmentKey.create(PathTemplateMatch.class);
    private final PathTemplateMatcher<HttpHandler> pathTemplateMatcher = new PathTemplateMatcher();

    public PathTemplateHandler() {
        this(true);
    }

    public PathTemplateHandler(boolean rewriteQueryParameters) {
        this(ResponseCodeHandler.HANDLE_404, rewriteQueryParameters);
    }

    public PathTemplateHandler(HttpHandler next) {
        this(next, true);
    }

    public PathTemplateHandler(HttpHandler next, boolean rewriteQueryParameters) {
        this.rewriteQueryParameters = rewriteQueryParameters;
        this.next = next;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        PathTemplateMatcher.PathMatchResult<HttpHandler> match = this.pathTemplateMatcher.match(exchange.getRelativePath());
        if (match == null) {
            this.next.handleRequest(exchange);
            return;
        }
        exchange.putAttachment(PATH_TEMPLATE_MATCH, new PathTemplateMatch(match.getMatchedTemplate(), match.getParameters()));
        exchange.putAttachment(libs.io.undertow.util.PathTemplateMatch.ATTACHMENT_KEY, new libs.io.undertow.util.PathTemplateMatch(match.getMatchedTemplate(), match.getParameters()));
        if (this.rewriteQueryParameters) {
            for (Map.Entry<String, String> entry : match.getParameters().entrySet()) {
                exchange.addQueryParam(entry.getKey(), entry.getValue());
            }
        }
        match.getValue().handleRequest(exchange);
    }

    public PathTemplateHandler add(String uriTemplate, HttpHandler handler) {
        this.pathTemplateMatcher.add(uriTemplate, handler);
        return this;
    }

    public PathTemplateHandler remove(String uriTemplate) {
        this.pathTemplateMatcher.remove(uriTemplate);
        return this;
    }

    public String toString() {
        Set<PathTemplate> paths = this.pathTemplateMatcher.getPathTemplates();
        if (paths.size() == 1) {
            return "path-template( " + String.valueOf(paths.toArray()[0]) + " )";
        }
        return "path-template( {" + paths.stream().map(s -> s.getTemplateString().toString()).collect(Collectors.joining(", ")) + "} )";
    }

    @Deprecated
    public static final class PathTemplateMatch {
        private final String matchedTemplate;
        private final Map<String, String> parameters;

        public PathTemplateMatch(String matchedTemplate, Map<String, String> parameters) {
            this.matchedTemplate = matchedTemplate;
            this.parameters = parameters;
        }

        public String getMatchedTemplate() {
            return this.matchedTemplate;
        }

        public Map<String, String> getParameters() {
            return this.parameters;
        }
    }
}

