/*
 * Decompiled with CFR 0.152.
 */
package libs.io.undertow.server.handlers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import libs.io.undertow.server.HandlerWrapper;
import libs.io.undertow.server.HttpHandler;
import libs.io.undertow.server.HttpServerExchange;
import libs.io.undertow.server.handlers.builder.HandlerBuilder;

public class SetErrorHandler
implements HttpHandler {
    private final int responseCode;
    private final HttpHandler next;

    public SetErrorHandler(HttpHandler next, int responseCode) {
        this.next = next;
        this.responseCode = responseCode;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        exchange.setStatusCode(this.responseCode);
        this.next.handleRequest(exchange);
    }

    public String toString() {
        return "set-error( " + this.responseCode + " )";
    }

    private static class Wrapper
    implements HandlerWrapper {
        private final Integer responseCode;

        private Wrapper(Integer responseCode) {
            this.responseCode = responseCode;
        }

        @Override
        public HttpHandler wrap(HttpHandler handler) {
            return new SetErrorHandler(handler, this.responseCode);
        }
    }

    public static class Builder
    implements HandlerBuilder {
        @Override
        public String name() {
            return "set-error";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            HashMap params = new HashMap();
            params.put("response-code", Integer.class);
            return params;
        }

        @Override
        public Set<String> requiredParameters() {
            HashSet<String> req = new HashSet<String>();
            req.add("response-code");
            return req;
        }

        @Override
        public String defaultParameter() {
            return "response-code";
        }

        @Override
        public HandlerWrapper build(Map<String, Object> config) {
            return new Wrapper((Integer)config.get("response-code"));
        }
    }
}

