/*
 * Decompiled with CFR 0.152.
 */
package libs.io.undertow.server.handlers.error;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import libs.io.undertow.Handlers;
import libs.io.undertow.io.Sender;
import libs.io.undertow.server.DefaultResponseListener;
import libs.io.undertow.server.HttpHandler;
import libs.io.undertow.server.HttpServerExchange;
import libs.io.undertow.server.handlers.ResponseCodeHandler;
import libs.io.undertow.util.Headers;
import libs.io.undertow.util.StatusCodes;

public class SimpleErrorPageHandler
implements HttpHandler {
    private volatile HttpHandler next = ResponseCodeHandler.HANDLE_404;
    private volatile Set<Integer> responseCodes = null;
    private final DefaultResponseListener responseListener = new DefaultResponseListener(){

        @Override
        public boolean handleDefaultResponse(HttpServerExchange exchange) {
            if (!exchange.isResponseChannelAvailable()) {
                return false;
            }
            Set<Integer> codes = SimpleErrorPageHandler.this.responseCodes;
            if (codes == null ? exchange.getStatusCode() >= 400 : codes.contains(exchange.getStatusCode())) {
                String errorPage = "<html><head><title>Error</title></head><body>" + exchange.getStatusCode() + " - " + StatusCodes.getReason(exchange.getStatusCode()) + "</body></html>";
                exchange.getResponseHeaders().put(Headers.CONTENT_LENGTH, "" + errorPage.length());
                exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "text/html");
                Sender sender = exchange.getResponseSender();
                sender.send(errorPage);
                return true;
            }
            return false;
        }
    };

    public SimpleErrorPageHandler(HttpHandler next) {
        this.next = next;
    }

    public SimpleErrorPageHandler() {
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        exchange.addDefaultResponseListener(this.responseListener);
        this.next.handleRequest(exchange);
    }

    public HttpHandler getNext() {
        return this.next;
    }

    public SimpleErrorPageHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull(next);
        this.next = next;
        return this;
    }

    public Set<Integer> getResponseCodes() {
        return Collections.unmodifiableSet(this.responseCodes);
    }

    public SimpleErrorPageHandler setResponseCodes(Set<Integer> responseCodes) {
        this.responseCodes = new HashSet<Integer>(responseCodes);
        return this;
    }

    public SimpleErrorPageHandler setResponseCodes(Integer ... responseCodes) {
        this.responseCodes = new HashSet<Integer>(Arrays.asList(responseCodes));
        return this;
    }
}

