/*
 * Decompiled with CFR 0.152.
 */
package libs.io.undertow.server.handlers.form;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import libs.io.undertow.UndertowLogger;
import libs.io.undertow.UndertowMessages;
import libs.io.undertow.UndertowOptions;
import libs.io.undertow.connector.PooledByteBuffer;
import libs.io.undertow.server.HttpHandler;
import libs.io.undertow.server.HttpServerExchange;
import libs.io.undertow.server.handlers.form.FormData;
import libs.io.undertow.server.handlers.form.FormDataParser;
import libs.io.undertow.server.handlers.form.FormParserFactory;
import libs.io.undertow.util.Headers;
import libs.io.undertow.util.SameThreadExecutor;
import libs.io.undertow.util.URLUtils;
import libs.io.undertow.util.UrlDecodeException;
import libs.org.xnio.ChannelListener;
import libs.org.xnio.IoUtils;
import libs.org.xnio.channels.StreamSourceChannel;

public class FormEncodedDataDefinition
implements FormParserFactory.ParserDefinition<FormEncodedDataDefinition> {
    public static final String APPLICATION_X_WWW_FORM_URLENCODED = "application/x-www-form-urlencoded";
    private static boolean parseExceptionLogAsDebug = false;
    private String defaultEncoding = "ISO-8859-1";
    private boolean forceCreation = false;

    @Override
    public FormDataParser create(HttpServerExchange exchange) {
        String mimeType = exchange.getRequestHeaders().getFirst(Headers.CONTENT_TYPE);
        if (this.forceCreation || mimeType != null && mimeType.startsWith(APPLICATION_X_WWW_FORM_URLENCODED)) {
            String cs;
            String charset = this.defaultEncoding;
            String contentType = exchange.getRequestHeaders().getFirst(Headers.CONTENT_TYPE);
            if (contentType != null && (cs = Headers.extractQuotedValueFromHeader(contentType, "charset")) != null) {
                charset = cs;
            }
            UndertowLogger.REQUEST_LOGGER.tracef("Created form encoded parser for %s", (Object)exchange);
            return new FormEncodedDataParser(charset, exchange);
        }
        return null;
    }

    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public boolean isForceCreation() {
        return this.forceCreation;
    }

    public FormEncodedDataDefinition setForceCreation(boolean forceCreation) {
        this.forceCreation = forceCreation;
        return this;
    }

    @Override
    public FormEncodedDataDefinition setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
        return this;
    }

    private static final class FormEncodedDataParser
    implements ChannelListener<StreamSourceChannel>,
    FormDataParser {
        private final HttpServerExchange exchange;
        private final FormData data;
        private final StringBuilder builder = new StringBuilder();
        private String name = null;
        private String charset;
        private HttpHandler handler;
        private int state = 0;

        private FormEncodedDataParser(String charset, HttpServerExchange exchange) {
            this.exchange = exchange;
            this.charset = charset;
            this.data = new FormData(exchange.getConnection().getUndertowOptions().get(UndertowOptions.MAX_PARAMETERS, 1000));
        }

        @Override
        public void handleEvent(StreamSourceChannel channel) {
            try {
                this.doParse(channel);
                if (this.state == 4) {
                    this.exchange.dispatch(SameThreadExecutor.INSTANCE, this.handler);
                }
            }
            catch (IOException e) {
                IoUtils.safeClose((Closeable)channel);
                UndertowLogger.REQUEST_IO_LOGGER.ioExceptionReadingFromChannel(e);
                this.exchange.endExchange();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doParse(StreamSourceChannel channel) throws IOException {
            int c = 0;
            try (PooledByteBuffer pooled = this.exchange.getConnection().getByteBufferPool().allocate();){
                ByteBuffer buffer = pooled.getBuffer();
                do {
                    buffer.clear();
                    c = channel.read(buffer);
                    if (c <= 0) continue;
                    buffer.flip();
                    while (buffer.hasRemaining()) {
                        byte n = buffer.get();
                        switch (this.state) {
                            case 0: {
                                if (n == 61) {
                                    this.name = this.builder.toString();
                                    this.builder.setLength(0);
                                    this.state = 2;
                                    break;
                                }
                                if (n == 38) {
                                    this.addPair(this.builder.toString(), "");
                                    this.builder.setLength(0);
                                    this.state = 0;
                                    break;
                                }
                                if (n == 37 || n == 43 || n < 0) {
                                    this.state = 1;
                                    this.builder.append((char)(n & 0xFF));
                                    break;
                                }
                                this.builder.append((char)n);
                                break;
                            }
                            case 1: {
                                if (n == 61) {
                                    this.name = this.decodeParameterName(this.builder.toString(), this.charset, true, new StringBuilder());
                                    this.builder.setLength(0);
                                    this.state = 2;
                                    break;
                                }
                                if (n == 38) {
                                    this.addPair(this.decodeParameterName(this.builder.toString(), this.charset, true, new StringBuilder()), "");
                                    this.builder.setLength(0);
                                    this.state = 0;
                                    break;
                                }
                                this.builder.append((char)(n & 0xFF));
                                break;
                            }
                            case 2: {
                                if (n == 38) {
                                    this.addPair(this.name, this.builder.toString());
                                    this.builder.setLength(0);
                                    this.state = 0;
                                    break;
                                }
                                if (n == 37 || n == 43 || n < 0) {
                                    this.state = 3;
                                    this.builder.append((char)(n & 0xFF));
                                    break;
                                }
                                this.builder.append((char)n);
                                break;
                            }
                            case 3: {
                                if (n == 38) {
                                    this.addPair(this.name, this.decodeParameterValue(this.name, this.builder.toString(), this.charset, true, new StringBuilder()));
                                    this.builder.setLength(0);
                                    this.state = 0;
                                    break;
                                }
                                this.builder.append((char)(n & 0xFF));
                            }
                        }
                    }
                } while (c > 0);
                if (c == -1) {
                    if (this.state == 2) {
                        this.addPair(this.name, this.builder.toString());
                    } else if (this.state == 3) {
                        this.addPair(this.name, this.decodeParameterValue(this.name, this.builder.toString(), this.charset, true, new StringBuilder()));
                    } else if (this.builder.length() > 0) {
                        if (this.state == 1) {
                            this.addPair(this.decodeParameterName(this.builder.toString(), this.charset, true, new StringBuilder()), "");
                        } else {
                            this.addPair(this.builder.toString(), "");
                        }
                    }
                    this.state = 4;
                    this.exchange.putAttachment(FORM_DATA, this.data);
                }
            }
        }

        private void addPair(String name, String value) {
            if (name != null && value != null) {
                this.data.add(name, value);
            }
        }

        private String decodeParameterValue(String name, String value, String charset, boolean decodeSlash, StringBuilder stringBuilder) {
            String decodedValue = null;
            try {
                decodedValue = URLUtils.decode(value, charset, decodeSlash, stringBuilder);
            }
            catch (UrlDecodeException e) {
                if (!parseExceptionLogAsDebug) {
                    UndertowLogger.REQUEST_LOGGER.errorf(UndertowMessages.MESSAGES.failedToDecodeParameterValue(name, value, e), new Object[0]);
                    parseExceptionLogAsDebug = true;
                }
                UndertowLogger.REQUEST_LOGGER.debugf(UndertowMessages.MESSAGES.failedToDecodeParameterValue(name, value, e), new Object[0]);
            }
            return decodedValue;
        }

        private String decodeParameterName(String name, String charset, boolean decodeSlash, StringBuilder stringBuilder) {
            String decodedName = null;
            try {
                decodedName = URLUtils.decode(name, charset, decodeSlash, stringBuilder);
            }
            catch (UrlDecodeException e) {
                if (!parseExceptionLogAsDebug) {
                    UndertowLogger.REQUEST_LOGGER.errorf(UndertowMessages.MESSAGES.failedToDecodeParameterName(name, e), new Object[0]);
                    parseExceptionLogAsDebug = true;
                }
                UndertowLogger.REQUEST_LOGGER.debugf(UndertowMessages.MESSAGES.failedToDecodeParameterName(name, e), new Object[0]);
            }
            return decodedName;
        }

        @Override
        public void parse(HttpHandler handler) throws Exception {
            if (this.exchange.getAttachment(FORM_DATA) != null) {
                handler.handleRequest(this.exchange);
                return;
            }
            this.handler = handler;
            StreamSourceChannel channel = this.exchange.getRequestChannel();
            if (channel == null) {
                throw new IOException(UndertowMessages.MESSAGES.requestChannelAlreadyProvided());
            }
            this.doParse(channel);
            if (this.state != 4) {
                channel.getReadSetter().set(this);
                channel.resumeReads();
            } else {
                this.exchange.dispatch(SameThreadExecutor.INSTANCE, handler);
            }
        }

        @Override
        public FormData parseBlocking() throws IOException {
            FormData existing = (FormData)this.exchange.getAttachment(FORM_DATA);
            if (existing != null) {
                return existing;
            }
            StreamSourceChannel channel = this.exchange.getRequestChannel();
            if (channel == null) {
                throw new IOException(UndertowMessages.MESSAGES.requestChannelAlreadyProvided());
            }
            while (this.state != 4) {
                this.doParse(channel);
                if (this.state == 4) continue;
                channel.awaitReadable();
            }
            return this.data;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void setCharacterEncoding(String encoding) {
            this.charset = encoding;
        }
    }
}

