/*
 * Decompiled with CFR 0.152.
 */
package libs.io.undertow.server.handlers.resource;

import java.io.IOException;
import java.net.URL;
import libs.io.undertow.UndertowMessages;
import libs.io.undertow.server.handlers.resource.Resource;
import libs.io.undertow.server.handlers.resource.ResourceChangeListener;
import libs.io.undertow.server.handlers.resource.ResourceManager;
import libs.io.undertow.server.handlers.resource.URLResource;

public class ClassPathResourceManager
implements ResourceManager {
    private final ClassLoader classLoader;
    private final String prefix;

    public ClassPathResourceManager(ClassLoader loader, Package p) {
        this(loader, p.getName().replace(".", "/"));
    }

    public ClassPathResourceManager(ClassLoader classLoader, String prefix) {
        this.classLoader = classLoader;
        this.prefix = prefix.isEmpty() ? "" : (prefix.endsWith("/") ? prefix : prefix + "/");
    }

    public ClassPathResourceManager(ClassLoader classLoader) {
        this(classLoader, "");
    }

    @Override
    public Resource getResource(String path) throws IOException {
        String realPath;
        URL resource;
        if (path == null) {
            return null;
        }
        String modPath = path;
        if (modPath.startsWith("/")) {
            modPath = path.substring(1);
        }
        if ((resource = this.classLoader.getResource(realPath = this.prefix + modPath)) == null) {
            return null;
        }
        return new URLResource(resource, path);
    }

    @Override
    public boolean isResourceChangeListenerSupported() {
        return false;
    }

    @Override
    public void registerResourceChangeListener(ResourceChangeListener listener) {
        throw UndertowMessages.MESSAGES.resourceChangeListenerNotSupported();
    }

    @Override
    public void removeResourceChangeListener(ResourceChangeListener listener) {
        throw UndertowMessages.MESSAGES.resourceChangeListenerNotSupported();
    }

    @Override
    public void close() throws IOException {
    }
}

