/*
 * Decompiled with CFR 0.152.
 */
package libs.io.undertow.server.protocol.ajp;

import java.io.Closeable;
import libs.io.undertow.UndertowMessages;
import libs.io.undertow.connector.ByteBufferPool;
import libs.io.undertow.server.AbstractServerConnection;
import libs.io.undertow.server.BasicSSLSessionInfo;
import libs.io.undertow.server.HttpHandler;
import libs.io.undertow.server.HttpServerExchange;
import libs.io.undertow.server.HttpUpgradeListener;
import libs.io.undertow.server.SSLSessionInfo;
import libs.io.undertow.server.protocol.ajp.AjpReadListener;
import libs.io.undertow.util.DateUtils;
import libs.org.xnio.IoUtils;
import libs.org.xnio.OptionMap;
import libs.org.xnio.StreamConnection;
import libs.org.xnio.conduits.ConduitStreamSinkChannel;
import libs.org.xnio.conduits.StreamSinkConduit;
import libs.org.xnio.conduits.WriteReadyHandler;

public final class AjpServerConnection
extends AbstractServerConnection {
    private SSLSessionInfo sslSessionInfo;
    private WriteReadyHandler.ChannelListenerHandler<ConduitStreamSinkChannel> writeReadyHandler;
    private AjpReadListener ajpReadListener;

    public AjpServerConnection(StreamConnection channel, ByteBufferPool bufferPool, HttpHandler rootHandler, OptionMap undertowOptions, int bufferSize) {
        super(channel, bufferPool, rootHandler, undertowOptions, bufferSize);
        this.writeReadyHandler = new WriteReadyHandler.ChannelListenerHandler<ConduitStreamSinkChannel>(channel.getSinkChannel());
    }

    @Override
    public HttpServerExchange sendOutOfBandResponse(HttpServerExchange exchange) {
        throw UndertowMessages.MESSAGES.outOfBandResponseNotSupported();
    }

    @Override
    public boolean isContinueResponseSupported() {
        return false;
    }

    @Override
    public void terminateRequestChannel(HttpServerExchange exchange) {
        if (!exchange.isPersistent()) {
            IoUtils.safeClose((Closeable)this.getChannel().getSourceChannel());
        }
    }

    @Override
    public void restoreChannel(AbstractServerConnection.ConduitState state) {
        super.restoreChannel(state);
        this.channel.getSinkChannel().getConduit().setWriteReadyHandler(this.writeReadyHandler);
    }

    @Override
    public AbstractServerConnection.ConduitState resetChannel() {
        AbstractServerConnection.ConduitState state = super.resetChannel();
        this.channel.getSinkChannel().getConduit().setWriteReadyHandler(this.writeReadyHandler);
        return state;
    }

    @Override
    public void clearChannel() {
        super.clearChannel();
        this.channel.getSinkChannel().getConduit().setWriteReadyHandler(this.writeReadyHandler);
    }

    @Override
    public SSLSessionInfo getSslSessionInfo() {
        return this.sslSessionInfo;
    }

    @Override
    public void setSslSessionInfo(SSLSessionInfo sessionInfo) {
        this.sslSessionInfo = sessionInfo;
    }

    void setSSLSessionInfo(BasicSSLSessionInfo sslSessionInfo) {
        this.sslSessionInfo = sslSessionInfo;
    }

    @Override
    protected StreamConnection upgradeChannel() {
        throw UndertowMessages.MESSAGES.upgradeNotSupported();
    }

    @Override
    protected StreamSinkConduit getSinkConduit(HttpServerExchange exchange, StreamSinkConduit conduit) {
        DateUtils.addDateHeaderIfRequired(exchange);
        return conduit;
    }

    @Override
    protected boolean isUpgradeSupported() {
        return false;
    }

    @Override
    protected boolean isConnectSupported() {
        return false;
    }

    void setAjpReadListener(AjpReadListener ajpReadListener) {
        this.ajpReadListener = ajpReadListener;
    }

    @Override
    protected void exchangeComplete(HttpServerExchange exchange) {
        this.ajpReadListener.exchangeComplete(exchange);
    }

    @Override
    protected void setConnectListener(HttpUpgradeListener connectListener) {
        throw UndertowMessages.MESSAGES.connectNotSupported();
    }

    void setCurrentExchange(HttpServerExchange exchange) {
        this.current = exchange;
    }

    @Override
    public String getTransportProtocol() {
        return "ajp";
    }

    @Override
    public boolean isRequestTrailerFieldsSupported() {
        return false;
    }
}

