/*
 * Decompiled with CFR 0.152.
 */
package libs.io.undertow.server.protocol.http2;

import java.io.IOException;
import java.security.cert.Certificate;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.cert.X509Certificate;
import libs.io.undertow.UndertowMessages;
import libs.io.undertow.protocols.http2.Http2Channel;
import libs.io.undertow.server.HttpServerExchange;
import libs.io.undertow.server.RenegotiationRequiredException;
import libs.io.undertow.server.SSLSessionInfo;
import libs.org.xnio.Options;
import libs.org.xnio.SslClientAuthMode;

class Http2SslSessionInfo
implements SSLSessionInfo {
    private final Http2Channel channel;

    Http2SslSessionInfo(Http2Channel channel) {
        this.channel = channel;
    }

    @Override
    public byte[] getSessionId() {
        return this.channel.getSslSession().getId();
    }

    @Override
    public String getCipherSuite() {
        return this.channel.getSslSession().getCipherSuite();
    }

    @Override
    public Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException, RenegotiationRequiredException {
        try {
            return this.channel.getSslSession().getPeerCertificates();
        }
        catch (SSLPeerUnverifiedException e) {
            try {
                SslClientAuthMode sslClientAuthMode = this.channel.getOption(Options.SSL_CLIENT_AUTH_MODE);
                if (sslClientAuthMode == SslClientAuthMode.NOT_REQUESTED) {
                    throw new RenegotiationRequiredException();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
    }

    @Override
    public X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException, RenegotiationRequiredException {
        try {
            return this.channel.getSslSession().getPeerCertificateChain();
        }
        catch (SSLPeerUnverifiedException e) {
            try {
                SslClientAuthMode sslClientAuthMode = this.channel.getOption(Options.SSL_CLIENT_AUTH_MODE);
                if (sslClientAuthMode == SslClientAuthMode.NOT_REQUESTED) {
                    throw new RenegotiationRequiredException();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
    }

    @Override
    public void renegotiate(HttpServerExchange exchange, SslClientAuthMode sslClientAuthMode) throws IOException {
        throw UndertowMessages.MESSAGES.renegotiationNotSupported();
    }

    @Override
    public SSLSession getSSLSession() {
        return this.channel.getSslSession();
    }
}

