/*
 * Decompiled with CFR 0.152.
 */
package libs.io.undertow.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;

public class FileUtils {
    private FileUtils() {
    }

    public static String readFile(Class<?> testClass, String fileName) {
        URL res = testClass.getResource(fileName);
        return FileUtils.readFile(res);
    }

    public static String readFile(URL url) {
        try {
            return FileUtils.readFile(url.openStream());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String readFile(InputStream file, String charset) {
        try {
            Charset charSet = charset != null ? Charset.forName(charset) : StandardCharsets.UTF_8;
            return FileUtils.readFile(file, charSet);
        }
        catch (UnsupportedCharsetException e) {
            throw new RuntimeException(e);
        }
    }

    public static String readFile(InputStream file) {
        return FileUtils.readFile(file, StandardCharsets.UTF_8);
    }

    public static String readFile(InputStream file, Charset charSet) {
        String string;
        BufferedInputStream stream = new BufferedInputStream(file);
        try {
            int read;
            byte[] buff = new byte[1024];
            StringBuilder builder = new StringBuilder();
            while ((read = stream.read(buff)) != -1) {
                builder.append(new String(buff, 0, read, charSet));
            }
            string = builder.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        stream.close();
        return string;
    }

    public static void deleteRecursive(Path directory) throws IOException {
        if (!Files.isDirectory(directory, new LinkOption[0])) {
            return;
        }
        Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                try {
                    Files.delete(file);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                try {
                    Files.delete(dir);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

