/*
 * Decompiled with CFR 0.152.
 */
package libs.io.undertow.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import libs.io.undertow.util.QValueParser;

public class LocaleUtils {
    public static Locale getLocaleFromString(String localeString) {
        if (localeString == null) {
            return null;
        }
        return Locale.forLanguageTag(localeString);
    }

    public static List<Locale> getLocalesFromHeader(String acceptLanguage) {
        if (acceptLanguage == null) {
            return Collections.emptyList();
        }
        return LocaleUtils.getLocalesFromHeader(Collections.singletonList(acceptLanguage));
    }

    public static List<Locale> getLocalesFromHeader(List<String> acceptLanguage) {
        if (acceptLanguage == null || acceptLanguage.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Locale> ret = new ArrayList<Locale>();
        List<List<QValueParser.QValueResult>> parsedResults = QValueParser.parse(acceptLanguage);
        for (List<QValueParser.QValueResult> qvalueResult : parsedResults) {
            for (QValueParser.QValueResult res : qvalueResult) {
                if (res.isQValueZero()) continue;
                Locale e = LocaleUtils.getLocaleFromString(res.getValue());
                ret.add(e);
            }
        }
        return ret;
    }
}

