/*
 * Decompiled with CFR 0.152.
 */
package libs.io.undertow.util;

import java.util.BitSet;
import libs.io.undertow.UndertowMessages;

public final class Rfc6265CookieSupport {
    private static final BitSet domainValid;

    public static void validateCookieValue(String value) {
        int start = 0;
        int end = value.length();
        if (end > 1 && value.charAt(0) == '\"' && value.charAt(end - 1) == '\"') {
            start = 1;
            --end;
        }
        char[] chars = value.toCharArray();
        for (int i = start; i < end; ++i) {
            char c = chars[i];
            if (c >= '!' && c != '\"' && c != ',' && c != ';' && c != '\\' && c != '\u007f') continue;
            throw UndertowMessages.MESSAGES.invalidCookieValue(Integer.toString(c));
        }
    }

    public static void validateDomain(String domain) {
        int prev = -1;
        int cur = -1;
        char[] chars = domain.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            prev = cur;
            cur = chars[i];
            if (!domainValid.get(cur)) {
                throw UndertowMessages.MESSAGES.invalidCookieDomain(domain);
            }
            if (!(prev != 46 && prev != -1 || cur != 46 && cur != 45)) {
                throw UndertowMessages.MESSAGES.invalidCookieDomain(domain);
            }
            if (prev != 45 || cur != 46) continue;
            throw UndertowMessages.MESSAGES.invalidCookieDomain(domain);
        }
        if (cur == 46 || cur == 45) {
            throw UndertowMessages.MESSAGES.invalidCookieDomain(domain);
        }
    }

    public static void validatePath(String path) {
        char[] chars = path.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char ch = chars[i];
            if (ch >= ' ' && ch <= '~' && ch != ';') continue;
            throw UndertowMessages.MESSAGES.invalidCookiePath(path);
        }
    }

    static {
        int c;
        domainValid = new BitSet(128);
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            domainValid.set(c);
        }
        for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
            domainValid.set(c);
        }
        for (c = 65; c <= 90; c = (int)((char)(c + 1))) {
            domainValid.set(c);
        }
        domainValid.set(46);
        domainValid.set(45);
    }
}

