/*
 * Decompiled with CFR 0.152.
 */
package libs.io.undertow.websockets;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import libs.io.undertow.server.HttpHandler;
import libs.io.undertow.server.HttpServerExchange;
import libs.io.undertow.server.HttpUpgradeListener;
import libs.io.undertow.server.handlers.ResponseCodeHandler;
import libs.io.undertow.util.Methods;
import libs.io.undertow.websockets.WebSocketConnectionCallback;
import libs.io.undertow.websockets.core.WebSocketChannel;
import libs.io.undertow.websockets.core.WebSocketLogger;
import libs.io.undertow.websockets.core.protocol.Handshake;
import libs.io.undertow.websockets.core.protocol.version07.Hybi07Handshake;
import libs.io.undertow.websockets.core.protocol.version08.Hybi08Handshake;
import libs.io.undertow.websockets.core.protocol.version13.Hybi13Handshake;
import libs.io.undertow.websockets.extensions.ExtensionHandshake;
import libs.io.undertow.websockets.spi.AsyncWebSocketHttpServerExchange;
import libs.org.xnio.StreamConnection;

public class WebSocketProtocolHandshakeHandler
implements HttpHandler {
    private final Set<Handshake> handshakes;
    private final HttpUpgradeListener upgradeListener;
    private final WebSocketConnectionCallback callback;
    private final Set<WebSocketChannel> peerConnections = Collections.newSetFromMap(new ConcurrentHashMap());
    private final HttpHandler next;

    public WebSocketProtocolHandshakeHandler(WebSocketConnectionCallback callback) {
        this(callback, (HttpHandler)ResponseCodeHandler.HANDLE_404);
    }

    public WebSocketProtocolHandshakeHandler(WebSocketConnectionCallback callback, HttpHandler next) {
        this.callback = callback;
        HashSet<Handshake> handshakes = new HashSet<Handshake>();
        handshakes.add(new Hybi13Handshake());
        handshakes.add(new Hybi08Handshake());
        handshakes.add(new Hybi07Handshake());
        this.handshakes = handshakes;
        this.next = next;
        this.upgradeListener = null;
    }

    public WebSocketProtocolHandshakeHandler(Collection<Handshake> handshakes, WebSocketConnectionCallback callback) {
        this(handshakes, callback, (HttpHandler)ResponseCodeHandler.HANDLE_404);
    }

    public WebSocketProtocolHandshakeHandler(Collection<Handshake> handshakes, WebSocketConnectionCallback callback, HttpHandler next) {
        this.callback = callback;
        this.handshakes = new HashSet<Handshake>(handshakes);
        this.next = next;
        this.upgradeListener = null;
    }

    public WebSocketProtocolHandshakeHandler(HttpUpgradeListener callback) {
        this(callback, (HttpHandler)ResponseCodeHandler.HANDLE_404);
    }

    public WebSocketProtocolHandshakeHandler(HttpUpgradeListener callback, HttpHandler next) {
        this.callback = null;
        HashSet<Handshake> handshakes = new HashSet<Handshake>();
        handshakes.add(new Hybi13Handshake());
        handshakes.add(new Hybi08Handshake());
        handshakes.add(new Hybi07Handshake());
        this.handshakes = handshakes;
        this.next = next;
        this.upgradeListener = callback;
    }

    public WebSocketProtocolHandshakeHandler(Collection<Handshake> handshakes, HttpUpgradeListener callback) {
        this(handshakes, callback, (HttpHandler)ResponseCodeHandler.HANDLE_404);
    }

    public WebSocketProtocolHandshakeHandler(Collection<Handshake> handshakes, HttpUpgradeListener callback, HttpHandler next) {
        this.callback = null;
        this.handshakes = new HashSet<Handshake>(handshakes);
        this.next = next;
        this.upgradeListener = callback;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (!exchange.getRequestMethod().equals(Methods.GET)) {
            this.next.handleRequest(exchange);
            return;
        }
        final AsyncWebSocketHttpServerExchange facade = new AsyncWebSocketHttpServerExchange(exchange, this.peerConnections);
        Handshake handshaker = null;
        for (Handshake method : this.handshakes) {
            if (!method.matches(facade)) continue;
            handshaker = method;
            break;
        }
        if (handshaker == null) {
            this.next.handleRequest(exchange);
        } else {
            WebSocketLogger.REQUEST_LOGGER.debugf("Attempting websocket handshake with %s on %s", (Object)handshaker, (Object)exchange);
            final Handshake selected = handshaker;
            if (this.upgradeListener == null) {
                exchange.upgradeChannel(new HttpUpgradeListener(){

                    @Override
                    public void handleUpgrade(StreamConnection streamConnection, HttpServerExchange exchange) {
                        WebSocketChannel channel = selected.createChannel(facade, streamConnection, facade.getBufferPool());
                        WebSocketProtocolHandshakeHandler.this.peerConnections.add(channel);
                        WebSocketProtocolHandshakeHandler.this.callback.onConnect(facade, channel);
                    }
                });
            } else {
                exchange.upgradeChannel(this.upgradeListener);
            }
            handshaker.handshake(facade);
        }
    }

    public Set<WebSocketChannel> getPeerConnections() {
        return this.peerConnections;
    }

    public WebSocketProtocolHandshakeHandler addExtension(ExtensionHandshake extension) {
        if (extension != null) {
            for (Handshake handshake : this.handshakes) {
                handshake.addExtension(extension);
            }
        }
        return this;
    }
}

