/*
 * Decompiled with CFR 0.152.
 */
package libs.io.undertow.websockets.core;

import libs.io.undertow.server.protocol.framed.AbstractFramedStreamSinkChannel;
import libs.io.undertow.websockets.core.StreamSourceFrameChannel;
import libs.io.undertow.websockets.core.WebSocketChannel;
import libs.io.undertow.websockets.core.WebSocketFrameType;
import libs.io.undertow.websockets.core.WebSocketMessages;

public abstract class StreamSinkFrameChannel
extends AbstractFramedStreamSinkChannel<WebSocketChannel, StreamSourceFrameChannel, StreamSinkFrameChannel> {
    private final WebSocketFrameType type;
    private int rsv;

    protected StreamSinkFrameChannel(WebSocketChannel channel, WebSocketFrameType type) {
        super(channel);
        this.type = type;
    }

    public int getRsv() {
        return this.rsv;
    }

    public void setRsv(int rsv) {
        if (!this.areExtensionsSupported() && rsv != 0) {
            throw WebSocketMessages.MESSAGES.extensionsNotSupported();
        }
        this.rsv = rsv;
    }

    public boolean isFragmentationSupported() {
        return false;
    }

    public boolean areExtensionsSupported() {
        return false;
    }

    public WebSocketFrameType getType() {
        return this.type;
    }

    public WebSocketChannel getWebSocketChannel() {
        return (WebSocketChannel)this.getChannel();
    }

    @Override
    protected boolean isLastFrame() {
        return this.type == WebSocketFrameType.CLOSE;
    }

    public boolean isFinalFragment() {
        return super.isFinalFrameQueued();
    }
}

