/*
 * Decompiled with CFR 0.152.
 */
package libs.net.querz.nbt.tag;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class Tag<T>
implements Cloneable {
    public static final int DEFAULT_MAX_DEPTH = 512;
    private static final Map<String, String> ESCAPE_CHARACTERS;
    private static final Pattern ESCAPE_PATTERN;
    private static final Pattern NON_QUOTE_PATTERN;
    private T value;

    public Tag(T value) {
        this.setValue(value);
    }

    public abstract byte getID();

    protected T getValue() {
        return this.value;
    }

    protected void setValue(T value) {
        this.value = this.checkValue(value);
    }

    protected T checkValue(T value) {
        return Objects.requireNonNull(value);
    }

    public final String toString() {
        return this.toString(512);
    }

    public String toString(int maxDepth) {
        return "{\"type\":\"" + this.getClass().getSimpleName() + "\",\"value\":" + this.valueToString(maxDepth) + "}";
    }

    public String valueToString() {
        return this.valueToString(512);
    }

    public abstract String valueToString(int var1);

    public boolean equals(Object other) {
        return other != null && this.getClass() == other.getClass();
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public abstract Tag<T> clone();

    protected static String escapeString(String s, boolean lenient) {
        StringBuffer sb = new StringBuffer();
        Matcher m = ESCAPE_PATTERN.matcher(s);
        while (m.find()) {
            m.appendReplacement(sb, ESCAPE_CHARACTERS.get(m.group()));
        }
        m.appendTail(sb);
        m = NON_QUOTE_PATTERN.matcher(s);
        if (!lenient || !m.matches()) {
            sb.insert(0, "\"").append("\"");
        }
        return sb.toString();
    }

    static {
        HashMap<String, String> temp = new HashMap<String, String>();
        temp.put("\\", "\\\\\\\\");
        temp.put("\n", "\\\\n");
        temp.put("\t", "\\\\t");
        temp.put("\r", "\\\\r");
        temp.put("\"", "\\\\\"");
        ESCAPE_CHARACTERS = Collections.unmodifiableMap(temp);
        ESCAPE_PATTERN = Pattern.compile("[\\\\\n\t\r\"]");
        NON_QUOTE_PATTERN = Pattern.compile("[a-zA-Z0-9_\\-+]+");
    }
}

