/*
 * Decompiled with CFR 0.152.
 */
package libs.org.wildfly.client.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Paths;
import java.security.AccessController;
import java.util.Set;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import libs.org.wildfly.client.config.BasicXMLStreamReader;
import libs.org.wildfly.client.config.ConfigXMLParseException;
import libs.org.wildfly.client.config.ConfigurationXMLStreamReader;
import libs.org.wildfly.client.config.SelectingXMLStreamReader;
import libs.org.wildfly.client.config.XIncludeXMLStreamReader;
import libs.org.wildfly.client.config.XMLLocation;
import libs.org.wildfly.client.config._private.ConfigMessages;
import libs.org.wildfly.common.Assert;
import libs.org.wildfly.common.function.ExceptionSupplier;

public class ClientConfiguration {
    private static final String WILDFLY_CLIENT_1_0 = "urn:wildfly:client:1.0";
    private final XMLInputFactory xmlInputFactory;
    private final URI configurationUri;
    private final ExceptionSupplier<InputStream, IOException> streamSupplier;

    ClientConfiguration(XMLInputFactory xmlInputFactory, URI configurationUri, ExceptionSupplier<InputStream, IOException> streamSupplier) {
        this.xmlInputFactory = xmlInputFactory;
        this.configurationUri = configurationUri;
        this.streamSupplier = streamSupplier;
    }

    ClientConfiguration(XMLInputFactory xmlInputFactory, URI configurationUri) {
        this.xmlInputFactory = xmlInputFactory;
        this.configurationUri = configurationUri;
        this.streamSupplier = this::streamOpener;
    }

    private InputStream streamOpener() throws IOException {
        URL url = this.configurationUri.toURL();
        URLConnection connection = url.openConnection();
        connection.setRequestProperty("Accept", "application/xml,text/xml,application/xhtml+xml");
        return connection.getInputStream();
    }

    XMLInputFactory getXmlInputFactory() {
        return this.xmlInputFactory;
    }

    public URI getConfigurationUri() {
        return this.configurationUri;
    }

    static ConfigurationXMLStreamReader openUri(URI uri, XMLInputFactory xmlInputFactory) throws ConfigXMLParseException {
        try {
            URL url = uri.toURL();
            URLConnection connection = url.openConnection();
            connection.setRequestProperty("Accept", "application/xml,text/xml,application/xhtml+xml");
            InputStream inputStream = connection.getInputStream();
            try {
                return ClientConfiguration.openUri(uri, xmlInputFactory, inputStream);
            }
            catch (Throwable t) {
                try {
                    inputStream.close();
                }
                catch (Throwable t2) {
                    t.addSuppressed(t2);
                }
                throw t;
            }
        }
        catch (MalformedURLException e) {
            throw ConfigMessages.msg.invalidUrl(new XMLLocation(uri), e);
        }
        catch (IOException e) {
            throw ConfigMessages.msg.failedToReadInput(new XMLLocation(uri), e);
        }
    }

    static ConfigurationXMLStreamReader openUri(URI uri, XMLInputFactory xmlInputFactory, InputStream inputStream) throws ConfigXMLParseException {
        try {
            return new BasicXMLStreamReader(null, xmlInputFactory.createXMLStreamReader(inputStream), uri, xmlInputFactory, inputStream);
        }
        catch (XMLStreamException e) {
            throw ConfigXMLParseException.from(e, uri, null);
        }
    }

    public ConfigurationXMLStreamReader readConfiguration(Set<String> recognizedNamespaces) throws ConfigXMLParseException {
        InputStream inputStream;
        URI uri = this.configurationUri;
        try {
            inputStream = this.streamSupplier.get();
        }
        catch (MalformedURLException e) {
            throw ConfigMessages.msg.invalidUrl(new XMLLocation(uri), e);
        }
        catch (IOException e) {
            throw ConfigMessages.msg.failedToReadInput(new XMLLocation(uri), e);
        }
        XIncludeXMLStreamReader reader = new XIncludeXMLStreamReader(ClientConfiguration.openUri(uri, this.xmlInputFactory, inputStream));
        try {
            if (reader.hasNext()) {
                switch (reader.nextTag()) {
                    case 1: {
                        String namespaceURI = reader.getNamespaceURI();
                        String localName = reader.getLocalName();
                        if (reader.hasNamespace() && !reader.namespaceURIEquals(WILDFLY_CLIENT_1_0)) {
                            throw ConfigMessages.msg.unexpectedElement(localName, namespaceURI, reader.getLocation());
                        }
                        if (reader.getAttributeCount() > 0) {
                            throw ConfigMessages.msg.unexpectedAttribute(reader.getAttributeName(0), reader.getLocation());
                        }
                        if (!"configuration".equals(localName)) {
                            if (namespaceURI == null) {
                                throw ConfigMessages.msg.unexpectedElement(localName, reader.getLocation());
                            }
                            throw ConfigMessages.msg.unexpectedElement(localName, namespaceURI, reader.getLocation());
                        }
                        return new SelectingXMLStreamReader(true, reader, recognizedNamespaces);
                    }
                }
                throw ConfigMessages.msg.unexpectedContent(ConfigurationXMLStreamReader.eventToString(reader.getEventType()), reader.getLocation());
            }
            reader.close();
            return null;
        }
        catch (Throwable t) {
            try {
                reader.close();
            }
            catch (Throwable t2) {
                t.addSuppressed(t2);
            }
            throw t;
        }
    }

    public static ClientConfiguration getInstance(URI configurationUri) {
        Assert.checkNotNullParam("configurationUri", configurationUri);
        return new ClientConfiguration(ClientConfiguration.createXmlInputFactory(), configurationUri);
    }

    public static ClientConfiguration getInstance(URI configurationUri, ExceptionSupplier<InputStream, IOException> streamSupplier) {
        Assert.checkNotNullParam("configurationUri", configurationUri);
        return new ClientConfiguration(ClientConfiguration.createXmlInputFactory(), configurationUri, streamSupplier);
    }

    private static XMLInputFactory createXmlInputFactory() {
        XMLInputFactory xmlInputFactory = XMLInputFactory.newFactory();
        xmlInputFactory.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
        xmlInputFactory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        xmlInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        return xmlInputFactory;
    }

    public static ClientConfiguration getInstance() {
        String wildFlyConfig = System.getProperty("wildfly.config.url");
        if (wildFlyConfig != null) {
            return ClientConfiguration.getInstance(ClientConfiguration.propertyUrlToUri(wildFlyConfig));
        }
        SecurityManager sm = System.getSecurityManager();
        ClassLoader classLoader = sm != null ? AccessController.doPrivileged(ClientConfiguration::getContextClassLoader) : ClientConfiguration.getContextClassLoader();
        if (classLoader == null) {
            classLoader = ClientConfiguration.class.getClassLoader();
        }
        return ClientConfiguration.getInstance(classLoader);
    }

    public static ClientConfiguration getInstance(ClassLoader classLoader) {
        URL resource = classLoader.getResource("wildfly-config.xml");
        if (resource == null && (resource = classLoader.getResource("META-INF/wildfly-config.xml")) == null) {
            return null;
        }
        try {
            return new ClientConfiguration(XMLInputFactory.newFactory(), resource.toURI(), resource::openStream);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    static URI propertyUrlToUri(String wildFlyConfig) {
        if (File.separator.equals("\\") && wildFlyConfig.contains("\\")) {
            File f = new File(wildFlyConfig);
            return f.toPath().toUri();
        }
        try {
            URI uri = new URI(wildFlyConfig);
            if (!uri.isAbsolute()) {
                if (uri.getPath().charAt(0) != File.separatorChar && uri.getPath().charAt(0) != '/') {
                    String userDir = System.getProperty("user.dir").replace(File.separatorChar, '/');
                    return Paths.get(userDir, uri.getPath()).toUri();
                }
                return Paths.get(uri.getPath(), new String[0]).toUri();
            }
            return uri;
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    private static ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }
}

