/*
 * Decompiled with CFR 0.152.
 */
package libs.org.wildfly.common.iteration;

import java.util.NoSuchElementException;
import libs.org.wildfly.common.iteration.ByteIterator;
import libs.org.wildfly.common.iteration.CodePointIterator;

final class Base16EncodingCodePointIterator
extends CodePointIterator {
    private ByteIterator iter;
    private final boolean toUpperCase;
    int b;
    boolean lo;

    Base16EncodingCodePointIterator(ByteIterator iter, boolean toUpperCase) {
        this.iter = iter;
        this.toUpperCase = toUpperCase;
    }

    @Override
    public boolean hasNext() {
        return this.lo || this.iter.hasNext();
    }

    @Override
    public boolean hasPrevious() {
        return this.lo || this.iter.hasPrevious();
    }

    private int hex(int i) {
        if (i < 10) {
            return 48 + i;
        }
        assert (i < 16);
        return (this.toUpperCase ? 65 : 97) + i - 10;
    }

    @Override
    public int next() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.lo) {
            this.lo = false;
            return this.hex(this.b & 0xF);
        }
        this.b = this.iter.next();
        this.lo = true;
        return this.hex(this.b >> 4);
    }

    @Override
    public int peekNext() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.lo) {
            return this.hex(this.b & 0xF);
        }
        return this.hex(this.iter.peekNext() >> 4);
    }

    @Override
    public int previous() throws NoSuchElementException {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        if (this.lo) {
            this.lo = false;
            this.iter.previous();
            return this.hex(this.b >> 4);
        }
        this.b = this.iter.peekPrevious();
        this.lo = true;
        return this.hex(this.b & 0xF);
    }

    @Override
    public int peekPrevious() throws NoSuchElementException {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        if (this.lo) {
            return this.hex(this.b >> 4);
        }
        return this.hex(this.iter.peekPrevious() & 0xF);
    }

    @Override
    public long getIndex() {
        return this.iter.getIndex() * 2L + (long)(this.lo ? 1 : 0);
    }
}

