/*
 * Decompiled with CFR 0.152.
 */
package libs.org.wildfly.common.iteration;

import libs.org.wildfly.common._private.CommonMessages;
import libs.org.wildfly.common.codec.Base32Alphabet;
import libs.org.wildfly.common.iteration.Base32DecodingByteIterator;
import libs.org.wildfly.common.iteration.CodePointIterator;

final class BigEndianBase32DecodingByteIterator
extends Base32DecodingByteIterator {
    private final Base32Alphabet alphabet;

    BigEndianBase32DecodingByteIterator(CodePointIterator iter, boolean requirePadding, Base32Alphabet alphabet) {
        super(iter, requirePadding);
        this.alphabet = alphabet;
    }

    @Override
    int calc0(int b0, int b1) {
        int d0 = this.alphabet.decode(b0);
        int d1 = this.alphabet.decode(b1);
        if (d0 == -1 || d1 == -1) {
            throw CommonMessages.msg.invalidBase32Character();
        }
        return (d0 << 3 | d1 >> 2) & 0xFF;
    }

    @Override
    int calc1(int b1, int b2, int b3) {
        int d1 = this.alphabet.decode(b1);
        int d2 = this.alphabet.decode(b2);
        int d3 = this.alphabet.decode(b3);
        if (d1 == -1 || d2 == -1 || d3 == -1) {
            throw CommonMessages.msg.invalidBase32Character();
        }
        return (d1 << 6 | d2 << 1 | d3 >> 4) & 0xFF;
    }

    @Override
    int calc2(int b3, int b4) {
        int d3 = this.alphabet.decode(b3);
        int d4 = this.alphabet.decode(b4);
        if (d3 == -1 || d4 == -1) {
            throw CommonMessages.msg.invalidBase32Character();
        }
        return (d3 << 4 | d4 >> 1) & 0xFF;
    }

    @Override
    int calc3(int b4, int b5, int b6) {
        int d4 = this.alphabet.decode(b4);
        int d5 = this.alphabet.decode(b5);
        int d6 = this.alphabet.decode(b6);
        if (d4 == -1 || d5 == -1 || d6 == -1) {
            throw CommonMessages.msg.invalidBase32Character();
        }
        return (d4 << 7 | d5 << 2 | d6 >> 3) & 0xFF;
    }

    @Override
    int calc4(int b6, int b7) {
        int d6 = this.alphabet.decode(b6);
        int d7 = this.alphabet.decode(b7);
        if (d6 == -1 || d7 == -1) {
            throw CommonMessages.msg.invalidBase32Character();
        }
        return (d6 << 5 | d7) & 0xFF;
    }
}

