/*
 * Decompiled with CFR 0.152.
 */
package libs.org.wildfly.common.iteration;

import libs.org.wildfly.common.codec.Base64Alphabet;
import libs.org.wildfly.common.iteration.Base64EncodingIterator;
import libs.org.wildfly.common.iteration.ByteIterator;

final class BigEndianBase64EncodingIterator
extends Base64EncodingIterator {
    private final Base64Alphabet alphabet;

    BigEndianBase64EncodingIterator(ByteIterator iter, boolean addPadding, Base64Alphabet alphabet) {
        super(iter, addPadding);
        this.alphabet = alphabet;
    }

    @Override
    int calc0(int b0) {
        return this.alphabet.encode(b0 >> 2 & 0x3F);
    }

    @Override
    int calc1(int b0, int b1) {
        return this.alphabet.encode((b0 << 4 | b1 >> 4) & 0x3F);
    }

    @Override
    int calc2(int b1, int b2) {
        return this.alphabet.encode((b1 << 2 | b2 >> 6) & 0x3F);
    }

    @Override
    int calc3(int b2) {
        return this.alphabet.encode(b2 & 0x3F);
    }
}

