/*
 * Decompiled with CFR 0.152.
 */
package libs.org.wildfly.common.xml;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import libs.org.wildfly.common.annotation.NotNull;
import libs.org.wildfly.common.xml.Log;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public final class SAXParserFactoryUtil {
    private static final AtomicBoolean TO_BE_LOGGED = new AtomicBoolean(true);

    @NotNull
    public static SAXParserFactory create() {
        SAXParserFactory instance;
        block11: {
            boolean toBeLogged;
            block10: {
                block9: {
                    block8: {
                        instance = SAXParserFactory.newInstance();
                        toBeLogged = TO_BE_LOGGED.compareAndSet(true, false);
                        try {
                            instance.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                        }
                        catch (ParserConfigurationException | SAXNotRecognizedException | SAXNotSupportedException e) {
                            if (!toBeLogged) break block8;
                            Log.XML_FACTORY_LOGGER.xmlFactoryPropertyNotSupported(e, "http://javax.xml.XMLConstants/feature/secure-processing", instance.getClass().getCanonicalName());
                        }
                    }
                    try {
                        instance.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                    }
                    catch (ParserConfigurationException | SAXNotRecognizedException | SAXNotSupportedException e) {
                        if (!toBeLogged) break block9;
                        Log.XML_FACTORY_LOGGER.xmlFactoryPropertyNotSupported(e, "http://apache.org/xml/features/disallow-doctype-decl", instance.getClass().getCanonicalName());
                    }
                }
                try {
                    instance.setFeature("http://xml.org/sax/features/external-general-entities", false);
                }
                catch (ParserConfigurationException | SAXNotRecognizedException | SAXNotSupportedException e) {
                    if (!toBeLogged) break block10;
                    Log.XML_FACTORY_LOGGER.xmlFactoryPropertyNotSupported(e, "http://xml.org/sax/features/external-general-entities", instance.getClass().getCanonicalName());
                }
            }
            try {
                instance.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            }
            catch (ParserConfigurationException | SAXNotRecognizedException | SAXNotSupportedException e) {
                if (!toBeLogged) break block11;
                Log.XML_FACTORY_LOGGER.xmlFactoryPropertyNotSupported(e, "http://xml.org/sax/features/external-parameter-entities", instance.getClass().getCanonicalName());
            }
        }
        return instance;
    }

    private SAXParserFactoryUtil() {
        throw new IllegalStateException("No instance");
    }
}

