/*
 * Decompiled with CFR 0.152.
 */
package libs.org.xnio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import libs.org.xnio.channels.StreamSinkChannel;
import libs.org.xnio.channels.StreamSourceChannel;

final class XnioFileChannel
extends FileChannel {
    private final FileChannel delegate;

    XnioFileChannel(FileChannel delegate) {
        this.delegate = delegate;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return this.delegate.read(dst);
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        return this.delegate.read(dsts, offset, length);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return this.delegate.write(src);
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return this.delegate.write(srcs, offset, length);
    }

    @Override
    public long position() throws IOException {
        return this.delegate.position();
    }

    @Override
    public FileChannel position(long newPosition) throws IOException {
        return this.delegate.position(newPosition);
    }

    @Override
    public long size() throws IOException {
        return this.delegate.size();
    }

    @Override
    public FileChannel truncate(long size) throws IOException {
        return this.delegate.truncate(size);
    }

    @Override
    public void force(boolean metaData) throws IOException {
        this.delegate.force(metaData);
    }

    @Override
    public long transferTo(long position, long count, WritableByteChannel target) throws IOException {
        if (target instanceof StreamSinkChannel) {
            return ((StreamSinkChannel)target).transferFrom(this.delegate, position, count);
        }
        return this.delegate.transferTo(position, count, target);
    }

    @Override
    public long transferFrom(ReadableByteChannel src, long position, long count) throws IOException {
        if (src instanceof StreamSourceChannel) {
            return ((StreamSourceChannel)src).transferTo(position, count, this.delegate);
        }
        return this.delegate.transferFrom(src, position, count);
    }

    @Override
    public int read(ByteBuffer dst, long position) throws IOException {
        return this.delegate.read(dst, position);
    }

    @Override
    public int write(ByteBuffer src, long position) throws IOException {
        return this.delegate.write(src, position);
    }

    @Override
    public MappedByteBuffer map(FileChannel.MapMode mode, long position, long size) throws IOException {
        return this.delegate.map(mode, position, size);
    }

    @Override
    public FileLock lock(long position, long size, boolean shared) throws IOException {
        return this.delegate.lock(position, size, shared);
    }

    @Override
    public FileLock tryLock(long position, long size, boolean shared) throws IOException {
        return this.delegate.tryLock(position, size, shared);
    }

    @Override
    public void implCloseChannel() throws IOException {
        this.delegate.close();
    }

    FileChannel getDelegate() {
        return this.delegate;
    }
}

