/*
 * Decompiled with CFR 0.152.
 */
package libs.org.xnio.conduits;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import libs.org.xnio.Buffers;
import libs.org.xnio.channels.StreamSourceChannel;
import libs.org.xnio.conduits.AbstractSinkConduit;
import libs.org.xnio.conduits.ConduitWritableByteChannel;
import libs.org.xnio.conduits.Conduits;
import libs.org.xnio.conduits.MessageSinkConduit;
import libs.org.xnio.conduits.StreamSinkConduit;

public final class MessageStreamSinkConduit
extends AbstractSinkConduit<MessageSinkConduit>
implements StreamSinkConduit {
    public MessageStreamSinkConduit(MessageSinkConduit next) {
        super(next);
    }

    @Override
    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        return src.transferTo(position, count, new ConduitWritableByteChannel(this));
    }

    @Override
    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        return Conduits.transfer(source, count, throughBuffer, this);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        int remaining = src.remaining();
        return ((MessageSinkConduit)this.next).send(src) ? remaining : 0;
    }

    @Override
    public long write(ByteBuffer[] srcs, int offs, int len) throws IOException {
        long remaining = Buffers.remaining(srcs, offs, len);
        return ((MessageSinkConduit)this.next).send(srcs, offs, len) ? remaining : 0L;
    }

    @Override
    public int writeFinal(ByteBuffer src) throws IOException {
        return Conduits.writeFinalBasic(this, src);
    }

    @Override
    public long writeFinal(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return Conduits.writeFinalBasic(this, srcs, offset, length);
    }
}

