/*
 * Decompiled with CFR 0.152.
 */
package libs.org.xnio.conduits;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import libs.org.xnio.Buffers;
import libs.org.xnio.Pooled;
import libs.org.xnio.channels.StreamSinkChannel;
import libs.org.xnio.conduits.AbstractStreamSourceConduit;
import libs.org.xnio.conduits.ReadReadyHandler;
import libs.org.xnio.conduits.StreamSourceConduit;

public final class PushBackStreamSourceConduit
extends AbstractStreamSourceConduit<StreamSourceConduit>
implements StreamSourceConduit {
    private StreamSourceConduit current;
    private boolean shutdown;

    public PushBackStreamSourceConduit(StreamSourceConduit next) {
        super(next);
        this.current = (StreamSourceConduit)this.next;
    }

    @Override
    public void resumeReads() {
        this.current.resumeReads();
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return this.current.read(dst);
    }

    @Override
    public long read(ByteBuffer[] dsts, int offs, int len) throws IOException {
        return this.current.read(dsts, offs, len);
    }

    @Override
    public long transferTo(long position, long count, FileChannel target) throws IOException {
        return this.current.transferTo(position, count, target);
    }

    @Override
    public long transferTo(long count, ByteBuffer throughBuffer, StreamSinkChannel target) throws IOException {
        return this.current.transferTo(count, throughBuffer, target);
    }

    @Override
    public void awaitReadable() throws IOException {
        this.current.awaitReadable();
    }

    @Override
    public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
        this.current.awaitReadable(time, timeUnit);
    }

    @Override
    public void terminateReads() throws IOException {
        this.shutdown = true;
        this.current.terminateReads();
    }

    @Override
    public void setReadReadyHandler(ReadReadyHandler handler) {
        this.current.setReadReadyHandler(handler);
    }

    public void pushBack(Pooled<ByteBuffer> pooledBuffer) {
        if (pooledBuffer == null) {
            return;
        }
        if (this.shutdown || !pooledBuffer.getResource().hasRemaining()) {
            pooledBuffer.free();
        } else {
            this.current = new BufferConduit(this.current, pooledBuffer);
        }
    }

    class BufferConduit
    extends AbstractStreamSourceConduit<StreamSourceConduit>
    implements StreamSourceConduit {
        private final Pooled<ByteBuffer> pooledBuffer;

        BufferConduit(StreamSourceConduit next, Pooled<ByteBuffer> pooledBuffer) {
            super(next);
            this.pooledBuffer = pooledBuffer;
        }

        @Override
        public void resumeReads() {
            ((StreamSourceConduit)this.next).wakeupReads();
        }

        @Override
        public void terminateReads() throws IOException {
            try {
                super.terminateReads();
            }
            finally {
                if (this.pooledBuffer != null) {
                    this.pooledBuffer.free();
                }
                ((StreamSourceConduit)this.next).terminateReads();
            }
        }

        @Override
        public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
        }

        @Override
        public void awaitReadable() throws IOException {
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            int cnt;
            if (!dst.hasRemaining()) {
                return 0;
            }
            StreamSourceConduit next = (StreamSourceConduit)this.next;
            try {
                ByteBuffer src = this.pooledBuffer.getResource();
                cnt = Buffers.copy(dst, src);
                if (src.hasRemaining()) {
                    return cnt;
                }
                this.moveToNext();
                if (cnt > 0 && next == PushBackStreamSourceConduit.this.next) {
                    return cnt;
                }
            }
            catch (IllegalStateException ignored) {
                this.moveToNext();
                cnt = 0;
            }
            int res = next.read(dst);
            return res > 0 ? res + cnt : (cnt > 0 ? cnt : res);
        }

        @Override
        public long read(ByteBuffer[] dsts, int offs, int len) throws IOException {
            long cnt;
            StreamSourceConduit next = (StreamSourceConduit)this.next;
            try {
                ByteBuffer src = this.pooledBuffer.getResource();
                cnt = Buffers.copy(dsts, offs, len, src);
                if (src.hasRemaining()) {
                    return cnt;
                }
                this.moveToNext();
                if (cnt > 0L && next == PushBackStreamSourceConduit.this.next) {
                    return cnt;
                }
            }
            catch (IllegalStateException ignored) {
                this.moveToNext();
                cnt = 0L;
            }
            long res = next.read(dsts, offs, len);
            return res > 0L ? res + cnt : (cnt > 0L ? cnt : res);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public long transferTo(long position, long count, FileChannel target) throws IOException {
            long cnt;
            try {
                ByteBuffer src = this.pooledBuffer.getResource();
                int pos = src.position();
                int rem = src.remaining();
                if ((long)rem <= count) {
                    cnt = target.write(src, position);
                    if (cnt != (long)rem) return cnt;
                    this.moveToNext();
                    return cnt + ((StreamSourceConduit)this.next).transferTo(position += cnt, count -= cnt, target);
                }
                try {
                    src.limit(pos + (int)count);
                    long l = target.write(src, position);
                    return l;
                }
                finally {
                    src.limit(pos + rem);
                }
            }
            catch (IllegalStateException ignored) {
                this.moveToNext();
                cnt = 0L;
            }
            return cnt + ((StreamSourceConduit)this.next).transferTo(position, count, target);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public long transferTo(long count, ByteBuffer throughBuffer, StreamSinkChannel target) throws IOException {
            long l;
            long cnt;
            try {
                ByteBuffer src = this.pooledBuffer.getResource();
                int pos = src.position();
                int rem = src.remaining();
                if ((long)rem > count) {
                    try {
                        src.limit(pos + (int)count);
                        int res = target.write(src);
                        if (res == 0) {
                            throughBuffer.clear();
                            Buffers.copy(throughBuffer, src);
                            throughBuffer.flip();
                        } else {
                            throughBuffer.clear();
                            throughBuffer.flip();
                        }
                        long l2 = res;
                        return l2;
                    }
                    finally {
                        src.limit(pos + rem);
                    }
                }
                cnt = target.write(src);
                if (cnt != (long)rem) {
                    if (cnt == 0L) {
                        throughBuffer.clear();
                        Buffers.copy(throughBuffer, src);
                        throughBuffer.flip();
                        return cnt;
                    }
                    throughBuffer.clear();
                    throughBuffer.flip();
                    return cnt;
                }
                this.moveToNext();
            }
            catch (IllegalStateException ignored) {
                this.moveToNext();
                cnt = 0L;
            }
            long res = ((StreamSourceConduit)this.next).transferTo(count - cnt, throughBuffer, target);
            if (res > 0L) {
                l = cnt + res;
                return l;
            }
            if (cnt > 0L) {
                l = cnt;
                return l;
            }
            l = res;
            return l;
        }

        private final void moveToNext() {
            PushBackStreamSourceConduit.this.current = (StreamSourceConduit)this.next;
            this.pooledBuffer.free();
        }
    }
}

