/*
 * Decompiled with CFR 0.152.
 */
package libs.org.xnio.conduits;

import libs.org.xnio.ChannelListener;
import libs.org.xnio.ChannelListeners;
import libs.org.xnio.IoUtils;
import libs.org.xnio.channels.CloseListenerSettable;
import libs.org.xnio.channels.ReadListenerSettable;
import libs.org.xnio.channels.SuspendableReadChannel;
import libs.org.xnio.conduits.TerminateHandler;

public interface ReadReadyHandler
extends TerminateHandler {
    public void readReady();

    public static class ReadyTask
    implements Runnable {
        private final ReadReadyHandler handler;

        public ReadyTask(ReadReadyHandler handler) {
            this.handler = handler;
        }

        @Override
        public void run() {
            this.handler.readReady();
        }
    }

    public static class ChannelListenerHandler<C extends SuspendableReadChannel & ReadListenerSettable<C>>
    implements ReadReadyHandler {
        private final C channel;

        public ChannelListenerHandler(C channel) {
            this.channel = channel;
        }

        @Override
        public void forceTermination() {
            IoUtils.safeClose(this.channel);
        }

        @Override
        public void readReady() {
            ChannelListener readListener = ((ReadListenerSettable)this.channel).getReadListener();
            if (readListener == null) {
                this.channel.suspendReads();
            } else {
                ChannelListeners.invokeChannelListener(this.channel, readListener);
            }
        }

        @Override
        public void terminated() {
            ChannelListeners.invokeChannelListener(this.channel, ((CloseListenerSettable)this.channel).getCloseListener());
        }
    }
}

