/*
 * Decompiled with CFR 0.152.
 */
package libs.org.xnio.sasl;

import java.nio.ByteBuffer;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import libs.org.xnio.sasl.SaslUtils;
import libs.org.xnio.sasl.SaslWrapper;

final class SaslClientWrapper
extends SaslWrapper {
    private final SaslClient saslClient;

    SaslClientWrapper(SaslClient saslClient) {
        this.saslClient = saslClient;
    }

    @Override
    public byte[] wrap(byte[] bytes, int off, int len) throws SaslException {
        return this.saslClient.wrap(bytes, off, len);
    }

    @Override
    public byte[] unwrap(byte[] bytes, int off, int len) throws SaslException {
        return this.saslClient.unwrap(bytes, off, len);
    }

    @Override
    public byte[] wrap(ByteBuffer source) throws SaslException {
        return SaslUtils.wrap(this.saslClient, source);
    }

    @Override
    public byte[] unwrap(ByteBuffer source) throws SaslException {
        return SaslUtils.unwrap(this.saslClient, source);
    }
}

