/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.bukkit;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.storage.Convertable;
import net.pl3x.map.core.Pl3xMap;
import net.pl3x.map.core.configuration.ColorsConfig;
import net.pl3x.map.core.event.world.WorldLoadedEvent;
import net.pl3x.map.core.markers.Point;
import net.pl3x.map.core.player.Player;
import net.pl3x.map.core.util.Colors;
import net.pl3x.map.core.util.Mathf;
import net.pl3x.map.core.world.World;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class BukkitWorld
extends World {
    private static Field LEVEL_STORAGE_ACCESS_FIELD = null;
    private final WorldServer level;

    private static Convertable.ConversionSession getLevelStorageAccess(WorldServer level) {
        try {
            return (Convertable.ConversionSession)LEVEL_STORAGE_ACCESS_FIELD.get(level);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public BukkitWorld(WorldServer level, String name) {
        super(name, level.H(), Point.of(level.F_().a().b().u(), level.F_().a().b().w()), World.Type.get(level.al().a().toString()), BukkitWorld.getLevelStorageAccess(level).a(level.al()).resolve("region"));
        this.level = level;
        if (!this.isEnabled()) {
            return;
        }
        this.init();
        Set entries = level.L_().f(Registries.aN).k();
        for (Map.Entry entry : entries) {
            String id = ((ResourceKey)entry.getKey()).a().toString();
            BiomeBase biome = (BiomeBase)entry.getValue();
            float temperature = Mathf.clamp(0.0f, 1.0f, biome.h());
            float humidity = Mathf.clamp(0.0f, 1.0f, biome.i.d());
            this.getBiomeRegistry().register(id, ColorsConfig.BIOME_COLORS.getOrDefault(id, 0), ColorsConfig.BIOME_DRY_FOLIAGE.getOrDefault(id, biome.i().f().orElse(Colors.getDefaultDryFoliageColor(temperature, humidity))), ColorsConfig.BIOME_FOLIAGE.getOrDefault(id, biome.i().e().orElse(Colors.getDefaultFoliageColor(temperature, humidity))), ColorsConfig.BIOME_GRASS.getOrDefault(id, biome.i().g().orElse(Colors.getDefaultGrassColor(temperature, humidity))), ColorsConfig.BIOME_WATER.getOrDefault(id, biome.i().b()), (x, z, color) -> biome.i().h().a((double)x, (double)z, color));
        }
        this.getBiomeRegistry().saveToDisk(this);
        Pl3xMap.api().getEventRegistry().callEvent(new WorldLoadedEvent(this));
    }

    @Override
    public <T> T getLevel() {
        return (T)this.level;
    }

    @Override
    public long hashSeed(long seed) {
        return BiomeManager.a((long)seed);
    }

    @Override
    public boolean hasCeiling() {
        return this.level.H_().h();
    }

    @Override
    public int getMinBuildHeight() {
        return this.level.M_();
    }

    @Override
    public int getMaxBuildHeight() {
        return this.level.ar() + 1;
    }

    @Override
    public int getDimensionHeight() {
        return this.level.H_().o();
    }

    @Override
    public int getLogicalHeight() {
        return this.level.m();
    }

    @Override
    public double getBorderMinX() {
        return this.level.u().c();
    }

    @Override
    public double getBorderMinZ() {
        return this.level.u().d();
    }

    @Override
    public double getBorderMaxX() {
        return this.level.u().e();
    }

    @Override
    public double getBorderMaxZ() {
        return this.level.u().f();
    }

    @Override
    public Collection<Player> getPlayers() {
        HashSet<Player> players = new HashSet<Player>();
        for (EntityPlayer serverPlayer : ((WorldServer)this.getLevel()).C()) {
            Player player = Pl3xMap.api().getPlayerRegistry().get(serverPlayer.cT());
            if (player == null) continue;
            players.add(player);
        }
        return players;
    }

    @Override
    public String toString() {
        return "BukkitWorld{name=" + this.getName() + ",seed=" + this.getSeed() + ",spawn=" + String.valueOf(this.getSpawn()) + "}";
    }

    static {
        if (LEVEL_STORAGE_ACCESS_FIELD == null) {
            Arrays.stream(WorldServer.class.getFields()).filter(field -> field.getType().equals(Convertable.ConversionSession.class)).findAny().ifPresent(field -> {
                LEVEL_STORAGE_ACCESS_FIELD = field;
            });
        }
    }
}

