/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import net.kyori.adventure.platform.AudienceProvider;
import net.pl3x.map.core.configuration.ColorsConfig;
import net.pl3x.map.core.configuration.Config;
import net.pl3x.map.core.configuration.Lang;
import net.pl3x.map.core.configuration.PlayersLayerConfig;
import net.pl3x.map.core.configuration.SpawnLayerConfig;
import net.pl3x.map.core.configuration.WorldBorderLayerConfig;
import net.pl3x.map.core.event.EventRegistry;
import net.pl3x.map.core.event.server.Pl3xMapDisabledEvent;
import net.pl3x.map.core.event.server.Pl3xMapEnabledEvent;
import net.pl3x.map.core.httpd.HttpdServer;
import net.pl3x.map.core.image.io.IO;
import net.pl3x.map.core.log.Logger;
import net.pl3x.map.core.metrics.Metrics;
import net.pl3x.map.core.player.PlayerRegistry;
import net.pl3x.map.core.registry.BlockRegistry;
import net.pl3x.map.core.registry.IconRegistry;
import net.pl3x.map.core.registry.RendererRegistry;
import net.pl3x.map.core.registry.WorldRegistry;
import net.pl3x.map.core.renderer.heightmap.HeightmapRegistry;
import net.pl3x.map.core.renderer.task.RegionDoubleChecker;
import net.pl3x.map.core.renderer.task.RegionProcessor;
import net.pl3x.map.core.renderer.task.UpdateSettingsData;
import net.pl3x.map.core.scheduler.Scheduler;
import net.pl3x.map.core.util.Mathf;
import net.pl3x.map.core.world.Biome;
import net.pl3x.map.core.world.Block;
import net.pl3x.map.core.world.Blocks;
import net.pl3x.map.core.world.World;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public abstract class Pl3xMap {
    private final boolean isBukkit;
    private final Attributes manifestAttributes;
    private final HttpdServer httpdServer;
    private final RegionProcessor regionProcessor;
    private final RegionDoubleChecker regionDoubleChecker;
    private final Scheduler scheduler;
    private final BlockRegistry blockRegistry;
    private final EventRegistry eventRegistry;
    private final HeightmapRegistry heightmapRegistry;
    private final IconRegistry iconRegistry;
    private final PlayerRegistry playerRegistry;
    private final RendererRegistry rendererRegistry;
    private final WorldRegistry worldRegistry;
    private ExecutorService renderExecutor;
    private String commit;
    private Metrics metrics;
    private boolean enabled;

    public static Pl3xMap api() {
        return Provider.api();
    }

    public Pl3xMap(boolean isBukkit) {
        Manifest manifest;
        this.isBukkit = isBukkit;
        try {
            Field api = Provider.class.getDeclaredField("api");
            api.setAccessible(true);
            api.set(null, this);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        try (JarFile jarFile = new JarFile(this.getJarPath().toFile());){
            JarEntry entry = jarFile.getJarEntry("META-INF/MANIFEST.MF");
            try (BufferedInputStream in = new BufferedInputStream(jarFile.getInputStream(entry));){
                manifest = new Manifest(in);
            }
        }
        catch (Exception e) {
            manifest = new Manifest();
            Logger.severe("Failed to obtain Manifest from META-INF", e);
        }
        this.manifestAttributes = manifest.getMainAttributes();
        this.httpdServer = new HttpdServer();
        this.regionProcessor = new RegionProcessor();
        this.regionDoubleChecker = new RegionDoubleChecker();
        this.scheduler = new Scheduler();
        this.blockRegistry = new BlockRegistry();
        this.eventRegistry = new EventRegistry();
        this.heightmapRegistry = new HeightmapRegistry();
        this.iconRegistry = new IconRegistry();
        this.playerRegistry = new PlayerRegistry();
        this.rendererRegistry = new RendererRegistry();
        this.worldRegistry = new WorldRegistry();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public HttpdServer getHttpdServer() {
        return this.httpdServer;
    }

    public RegionProcessor getRegionProcessor() {
        return this.regionProcessor;
    }

    public RegionDoubleChecker getRegionDoubleChecker() {
        return this.regionDoubleChecker;
    }

    public BlockRegistry getBlockRegistry() {
        return this.blockRegistry;
    }

    public EventRegistry getEventRegistry() {
        return this.eventRegistry;
    }

    public HeightmapRegistry getHeightmapRegistry() {
        return this.heightmapRegistry;
    }

    public IconRegistry getIconRegistry() {
        return this.iconRegistry;
    }

    public PlayerRegistry getPlayerRegistry() {
        return this.playerRegistry;
    }

    public RendererRegistry getRendererRegistry() {
        return this.rendererRegistry;
    }

    public WorldRegistry getWorldRegistry() {
        return this.worldRegistry;
    }

    public ExecutorService getRenderExecutor() {
        return this.renderExecutor;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void enable() {
        Logger.debug("Loading configs");
        Config.reload();
        Lang.reload();
        ColorsConfig.reload();
        PlayersLayerConfig.reload();
        SpawnLayerConfig.reload();
        WorldBorderLayerConfig.reload();
        this.getBlockRegistry().init();
        this.getIconRegistry().init();
        Logger.debug("Registering blocks");
        Blocks.registerDefaults();
        this.loadBlocks();
        Logger.debug("Creating services");
        this.renderExecutor = ThreadFactory.createService("Pl3xMap-Renderer", Config.RENDER_THREADS);
        Logger.debug("Registering tile image types");
        IO.register();
        Logger.debug("Registering heightmaps");
        this.getHeightmapRegistry().register();
        Logger.debug("Registering renderers");
        this.getRendererRegistry().register();
        this.enabled = true;
        new Pl3xMapEnabledEvent().callEvent();
        Logger.debug("Registering worlds");
        this.loadWorlds();
        Logger.debug("Registering players");
        this.loadPlayers();
        Logger.debug("Starting internal server");
        this.getHttpdServer().startServer();
        Logger.debug("Starting region processor");
        this.getRegionProcessor().start(10000L);
        this.getRegionDoubleChecker().start(250000L);
        Logger.debug("Starting update settings data task");
        this.getScheduler().addTask(new UpdateSettingsData());
        Logger.info("Platform: " + this.getPlatform());
        Logger.info("Version: " + this.getVersion());
        try {
            this.metrics = new Metrics(this);
        }
        catch (IOException e) {
            Logger.severe("Failed to generate or load default bStats config", e);
        }
        Pl3xMap.api().getRegionProcessor().setPaused(false);
    }

    public void disable() {
        Pl3xMap.api().getRegionProcessor().setPaused(true);
        if (this.metrics != null) {
            this.metrics.shutdown();
            this.metrics = null;
        }
        Logger.debug("Stopping tasks");
        this.getScheduler().cancelAll();
        this.getRegionDoubleChecker().stop();
        this.getRegionProcessor().stop();
        if (this.renderExecutor != null) {
            this.renderExecutor.shutdownNow();
        }
        Logger.debug("Stopping internal server");
        this.getHttpdServer().stopServer();
        this.enabled = false;
        new Pl3xMapDisabledEvent().callEvent();
        Logger.debug("Unregistering players");
        this.getPlayerRegistry().unregister();
        Logger.debug("Unregistering worlds");
        this.getWorldRegistry().unregister();
        Logger.debug("Unregistering renderers");
        this.getRendererRegistry().unregister();
        Logger.debug("Unregistering icons");
        this.getIconRegistry().unregister();
        Logger.debug("Unregistering heightmaps");
        this.getHeightmapRegistry().unregister();
        Logger.debug("Unregistering tile image types");
        IO.unregister();
        Logger.debug("Unregistering blocks");
        this.getBlockRegistry().unregister();
        System.gc();
    }

    public boolean isBukkit() {
        return this.isBukkit;
    }

    public abstract String getPlatform();

    public abstract String getVersion();

    public String getVersionCommit() {
        if (this.commit == null) {
            this.commit = this.manifestAttributes.getValue("Git-Commit");
            if (this.commit == null) {
                this.commit = "unknown";
            }
        }
        return this.commit;
    }

    public abstract int getMaxPlayers();

    public abstract boolean getOnlineMode();

    public abstract String getServerVersion();

    public abstract AudienceProvider adventure();

    public abstract Path getMainDir();

    public abstract Path getJarPath();

    public abstract int getColorForPower(byte var1);

    public abstract @Nullable Block getFlower(World var1, Biome var2, int var3, int var4, int var5);

    protected abstract void loadBlocks();

    protected abstract void loadWorlds();

    protected abstract void loadPlayers();

    public abstract World cloneWorld(World var1);

    protected static final class Provider {
        static Pl3xMap api;

        protected Provider() {
        }

        static Pl3xMap api() {
            return api;
        }
    }

    public static final class ThreadFactory
    implements ForkJoinPool.ForkJoinWorkerThreadFactory {
        private final String name;
        private final int threads;
        private final AtomicInteger id = new AtomicInteger();

        public ThreadFactory(String name, int threads) {
            this.name = name;
            this.threads = threads;
        }

        public static ExecutorService createService(String name) {
            return ThreadFactory.createService(new ThreadFactory(name, 1));
        }

        public static ExecutorService createService(String name, int threads) {
            int max = Math.max(1, Runtime.getRuntime().availableProcessors() / 2);
            int parallelism = Mathf.clamp(1, max, threads < 1 ? max : threads);
            return ThreadFactory.createService(new ThreadFactory(name, parallelism));
        }

        private static ExecutorService createService(ThreadFactory factory) {
            return new ForkJoinPool(factory.threads, factory, null, false);
        }

        @Override
        public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
            ForkJoinWorkerThread thread = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
            thread.setContextClassLoader(Pl3xMap.class.getClassLoader());
            thread.setName(this.threads > 1 ? String.format("%s-%d", this.name, this.id.getAndIncrement()) : this.name);
            return thread;
        }
    }
}

