/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.command.commands;

import java.util.Set;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.pl3x.map.core.Pl3xMap;
import net.pl3x.map.core.command.CommandHandler;
import net.pl3x.map.core.command.Pl3xMapCommand;
import net.pl3x.map.core.command.Sender;
import net.pl3x.map.core.configuration.Lang;
import net.pl3x.map.core.renderer.progress.Progress;
import net.pl3x.map.core.renderer.task.RegionProcessor;
import net.pl3x.map.core.world.World;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.minecraft.extras.RichDescription;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class StatusCommand
extends Pl3xMapCommand {
    public StatusCommand(CommandHandler handler) {
        super(handler);
    }

    @Override
    public void register() {
        this.getHandler().registerSubcommand(builder -> builder.literal("status", new String[0]).commandDescription(RichDescription.of(Lang.parse(Lang.COMMAND_STATUS_DESCRIPTION, new TagResolver.Single[0]))).permission("pl3xmap.command.status").handler(this::execute));
    }

    public void execute(CommandContext<Sender> context) {
        boolean isIdle;
        Sender sender = context.sender();
        String lineNext = "\u251c\u2500";
        String lineLast = "\u2514\u2500";
        String header = "<color:#5b00ff><strikethrough>---------------</strikethrough> <white>Pl3xMap Status</white> <strikethrough>---------------</strikethrough></color>";
        String footer = "<color:#5b00ff><strikethrough>----------------------------------------------</strikethrough></color>";
        String active = "<gray>Actively running renderers:</gray>\n<dark_gray><linelast></dark_gray> <color:#5b00ff>World:</color> <white><world></white>\n   <dark_gray><linenext></dark_gray> <white>chk:</white> <gray><processed_chunks>/<total_chunks></gray>\n   <dark_gray><linenext></dark_gray> <white>pct:</white> <gray><percent>%</gray>\n   <dark_gray><linenext></dark_gray> <white>cps:</white> <gray><cps></gray>\n   <dark_gray><linelast></dark_gray> <white>eta:</white> <gray><eta></gray>";
        String queuedHeader = "<gray>Queued up renderers:</gray>";
        String queuedEntry = "<dark_gray><line></dark_gray> <color:#5b00ff>World:</color> <white><world></white>";
        String paused = "<gray>Renderers are </gray><white>paused</white>";
        String idle = "<gray>Renderers are </gray><white>idle</white>";
        RegionProcessor processor = Pl3xMap.api().getRegionProcessor();
        Progress progress = processor.getProgress();
        StringBuilder sb = new StringBuilder();
        sb.append(header).append("\n");
        boolean isPaused = processor.isPaused();
        boolean bl = isIdle = progress.getWorld() == null;
        if (isPaused) {
            sb.append(paused);
        } else if (isIdle) {
            sb.append(idle);
        } else {
            sb.append(active);
        }
        sb.append("\n");
        Set<World> worlds = processor.getQueuedWorlds();
        if (!worlds.isEmpty()) {
            sb.append(queuedHeader).append("\n");
            int i = 0;
            for (World world : worlds) {
                sb.append(queuedEntry.replace("<world>", world.getName()).replace("<line>", i++ < worlds.size() ? lineNext : lineLast));
                sb.append("\n");
            }
        }
        sb.append(footer);
        if (isPaused || isIdle) {
            sender.sendMessage(sb.toString(), false);
            return;
        }
        sender.sendMessage(sb.toString(), false, Placeholder.unparsed("world", progress.getWorld().getName()), Placeholder.unparsed("processed_chunks", Long.toString(progress.getProcessedChunks().get())), Placeholder.unparsed("total_chunks", Long.toString(progress.getTotalChunks())), Placeholder.unparsed("processed_regions", Long.toString(progress.getProcessedRegions().get())), Placeholder.unparsed("total_regions", Long.toString(progress.getTotalRegions())), Placeholder.unparsed("percent", String.format("%.2f", Float.valueOf(progress.getPercent()))), Placeholder.unparsed("cps", String.format("%.2f", progress.getCPS())), Placeholder.unparsed("eta", progress.getETA()), Placeholder.unparsed("linenext", lineNext), Placeholder.unparsed("linelast", lineLast));
    }
}

