/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.command.parser;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeSet;
import net.pl3x.map.core.command.exception.ZoomParseException;
import net.pl3x.map.core.world.World;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.context.CommandInput;
import org.incendo.cloud.parser.ArgumentParseResult;
import org.incendo.cloud.parser.ArgumentParser;
import org.incendo.cloud.parser.ParserDescriptor;
import org.incendo.cloud.suggestion.BlockingSuggestionProvider;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class ZoomParser<C>
implements ArgumentParser<C, Integer>,
BlockingSuggestionProvider.Strings<C> {
    public static <C> ParserDescriptor<C, Integer> parser() {
        return ParserDescriptor.of(new ZoomParser<C>(), Integer.class);
    }

    @Override
    public ArgumentParseResult<Integer> parse(CommandContext<C> commandContext, CommandInput commandInput) {
        String input = commandInput.peekString();
        try {
            int zoom = Integer.parseInt(input);
            if (zoom < 0 || zoom > this.getMax(commandContext)) {
                return ArgumentParseResult.failure(new ZoomParseException(input, ZoomParseException.NOT_VALID_ZOOM_LEVEL));
            }
            commandInput.readString();
            return ArgumentParseResult.success(zoom);
        }
        catch (Exception e) {
            return ArgumentParseResult.failure(new ZoomParseException(input, ZoomParseException.NOT_VALID_ZOOM_LEVEL));
        }
    }

    @Override
    public Iterable<String> stringSuggestions(CommandContext<C> commandContext, CommandInput input) {
        TreeSet<Long> numbers = new TreeSet<Long>();
        String token = input.peekString();
        try {
            long inputNum = Long.parseLong(token.equals("-") ? "-0" : (token.isEmpty() ? "0" : token));
            long inputNumAbsolute = Math.abs(inputNum);
            numbers.add(inputNumAbsolute);
            int max = this.getMax(commandContext);
            for (int i = 0; i < 10 && inputNum * 10L + (long)i <= (long)max; ++i) {
                numbers.add(inputNumAbsolute * 10L + (long)i);
            }
            LinkedList<String> suggestions = new LinkedList<String>();
            Iterator iterator = numbers.iterator();
            while (iterator.hasNext()) {
                long number = (Long)iterator.next();
                if (token.startsWith("-")) {
                    number = -number;
                }
                if (number < 0L || number > (long)max) continue;
                suggestions.add(String.valueOf(number));
            }
            return suggestions;
        }
        catch (Exception ignored) {
            return Collections.emptyList();
        }
    }

    private int getMax(CommandContext<C> context) {
        return ((World)context.get((String)"world")).getConfig().ZOOM_MAX_OUT;
    }
}

