/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.configuration;

import net.pl3x.map.core.Pl3xMap;
import net.pl3x.map.core.configuration.AbstractConfig;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class PlayersLayerConfig
extends AbstractConfig {
    @AbstractConfig.Key(value="settings.enabled")
    @AbstractConfig.Comment(value="Show online players on the map and sidebar.")
    public static boolean ENABLED = true;
    @AbstractConfig.Key(value="settings.hide.invisible")
    @AbstractConfig.Comment(value="Should invisible players be hidden from the map.")
    public static boolean HIDE_INVISIBLE = true;
    @AbstractConfig.Key(value="settings.hide.spectators")
    @AbstractConfig.Comment(value="Should spectators be hidden from the map.")
    public static boolean HIDE_SPECTATORS = true;
    @AbstractConfig.Key(value="settings.layer.update-interval")
    @AbstractConfig.Comment(value="How often (in seconds) to update the marker.")
    public static int UPDATE_INTERVAL = 0;
    @AbstractConfig.Key(value="settings.layer.live-update")
    @AbstractConfig.Comment(value="Whether to push this layer through SSE or not.")
    public static boolean LIVE_UPDATE = true;
    @AbstractConfig.Key(value="settings.layer.show-controls")
    @AbstractConfig.Comment(value="Whether the players layer control shows up in the layers list or not.")
    public static boolean SHOW_CONTROLS = true;
    @AbstractConfig.Key(value="settings.layer.default-hidden")
    @AbstractConfig.Comment(value="Whether the players layer should be hidden (toggled off) by default.")
    public static boolean DEFAULT_HIDDEN = false;
    @AbstractConfig.Key(value="settings.layer.priority")
    @AbstractConfig.Comment(value="Priority order players layer shows up in the layers list.\n(lower values = higher in the list)")
    public static int PRIORITY = 20;
    @AbstractConfig.Key(value="settings.layer.z-index")
    @AbstractConfig.Comment(value="Z-Index order players layer shows up in the map.\n(higher values are drawn on top of lower values)")
    public static int Z_INDEX = 999;
    @AbstractConfig.Key(value="settings.icon")
    @AbstractConfig.Comment(value="The player icon.\nIcon must be in the web/images/icon/ directory.")
    public static String ICON = "players";
    @AbstractConfig.Key(value="settings.tooltip")
    @AbstractConfig.Comment(value="Tooltip for player markers.\nVariables: uuid, name, decoratedName, health, armor")
    public static String TOOLTIP = "<ul>\n  <li><img src='images/skins/2D/<uuid>.png' class='head' alt='<name>' /></li>\n  <li>\n    <name>\n    <img src='images/clear.png' class='health' style='background-position:0 calc(-<health>px * 9);' alt='Health <health>' />\n    <img src='images/clear.png' class='armor' style='background-position:0 calc(-<armor>px * 9);' alt='Armor <armor>' />\n  </li>\n</ul>";
    @AbstractConfig.Key(value="settings.pane")
    @AbstractConfig.Comment(value="The custom pane layer for the player tracker.\nThis is used to make custom css styled tooltips.\n(see css setting below)")
    public static String PANE = "nameplates";
    @AbstractConfig.Key(value="settings.css")
    @AbstractConfig.Comment(value="Custom css for players marker layer.\nClass names use the pane name set above.")
    public static String CSS = "div.leaflet-nameplates-pane div img.head {\n  image-rendering: pixelated;\n  image-rendering: -moz-crisp-edges;\n  -ms-interpolation-mode: nearest-neighbor;\n}\ndiv.leaflet-nameplates-pane div {\n  margin: 0;\n  padding: 0;\n  color: #ffffff;\n  font-weight: 700;\n  line-height: 1rem;\n  background: rgba(0, 0, 0, 0.5);\n  border-color: rgba(0, 0, 0, 0.75);\n}\ndiv.leaflet-nameplates-pane div ul {\n  padding: 3px;\n}\ndiv.leaflet-nameplates-pane div:before {\n  border-color: transparent;\n}\ndiv.leaflet-nameplates-pane div img.head {\n  vertical-align: middle;\n  width: 32px;\n  height: 32px;\n  border-radius: 5px;\n  border: 1px solid black;\n}\ndiv.leaflet-nameplates-pane div img.health {\n  margin-top: 3px;\n}\ndiv.leaflet-nameplates-pane div img.armor,\ndiv.leaflet-nameplates-pane div img.health {\n  display: block;\n  width: 81px;\n  height: 9px;\n  background-position: 0 0;\n}\ndiv.leaflet-nameplates-pane div img.armor {\n  background: url('images/armor.png') no-repeat;\n}\ndiv.leaflet-nameplates-pane div img.health {\n  background: url('images/health.png') no-repeat;\n}\ndiv.leaflet-nameplates-pane div,\ndiv.leaflet-marker-pane img {\n  transition: all 0.25s;\n}";
    private static final PlayersLayerConfig CONFIG = new PlayersLayerConfig();

    public static void reload() {
        CONFIG.reload(Pl3xMap.api().getMainDir().resolve("layers/players.yml"), PlayersLayerConfig.class);
    }
}

