/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.event;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import net.pl3x.map.core.event.Event;
import net.pl3x.map.core.event.EventHandler;
import net.pl3x.map.core.event.EventListener;
import net.pl3x.map.core.event.RegisteredHandler;
import net.pl3x.map.core.log.Logger;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class EventRegistry {
    public void callEvent(Event event) {
        for (RegisteredHandler handler : event.getHandlers()) {
            try {
                Logger.debug("Executing Event " + String.valueOf(handler));
                handler.execute(event);
            }
            catch (Throwable t) {
                Logger.severe("Failed to execute Event " + String.valueOf(handler), t);
            }
        }
    }

    public void register(EventListener listener) {
        for (Method method : listener.getClass().getMethods()) {
            if (method.getDeclaredAnnotation(EventHandler.class) == null) continue;
            Class<?>[] params = method.getParameterTypes();
            if (params.length == 0) {
                Logger.warn(String.format("Annotated EventListener does not have an Event param %s@%s", listener.getClass(), method.getName()));
                continue;
            }
            Class<?> event = params[0];
            if (!Event.class.isAssignableFrom(event)) {
                Logger.warn(String.format("%s is not an event", event.getName()));
                continue;
            }
            try {
                Field handlers = event.getDeclaredField("handlers");
                handlers.setAccessible(true);
                List list = (List)handlers.get(event);
                RegisteredHandler handler = new RegisteredHandler(listener, method);
                if (list.remove(handler)) {
                    Logger.debug("Remove previously registered event " + String.valueOf(handler));
                }
                list.add(handler);
                Logger.debug("Registered new addon event " + String.valueOf(handler));
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

