/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.httpd;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.stream.Collectors;
import libs.io.undertow.Handlers;
import libs.io.undertow.Undertow;
import libs.io.undertow.UndertowLogger;
import libs.io.undertow.UndertowOptions;
import libs.io.undertow.server.HttpServerExchange;
import libs.io.undertow.server.handlers.resource.PathResourceManager;
import libs.io.undertow.server.handlers.resource.ResourceHandler;
import libs.io.undertow.server.handlers.resource.ResourceManager;
import libs.io.undertow.util.ETag;
import libs.io.undertow.util.Headers;
import libs.io.undertow.util.HttpString;
import net.pl3x.map.core.Pl3xMap;
import net.pl3x.map.core.configuration.Config;
import net.pl3x.map.core.configuration.Lang;
import net.pl3x.map.core.httpd.LiveDataHandler;
import net.pl3x.map.core.log.LogFilter;
import net.pl3x.map.core.log.Logger;
import net.pl3x.map.core.registry.WorldRegistry;
import net.pl3x.map.core.util.FileUtil;
import net.pl3x.map.core.world.World;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class HttpdServer {
    private HttpString X_ACCEL_BUFFERING = new HttpString("X-Accel-Buffering");
    private Undertow server;
    private LiveDataHandler liveDataHandler = new LiveDataHandler();

    public LiveDataHandler getLiveDataHandler() {
        return this.liveDataHandler;
    }

    public void startServer() {
        if (!Config.HTTPD_ENABLED) {
            Logger.info(Lang.HTTPD_DISABLED);
            return;
        }
        try {
            ResourceManager resourceManager = PathResourceManager.builder().setBase(Paths.get(FileUtil.getWebDir().toFile().getAbsolutePath(), new String[0])).setFollowLinks(Config.HTTPD_FOLLOW_SYMLINKS).setETagFunction(path -> {
                try {
                    BasicFileAttributes attr = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
                    long time = attr.lastModifiedTime().toMillis();
                    return new ETag(false, Long.toString(time));
                }
                catch (IOException e) {
                    Logger.severe("Failed to read basic file attributes from file %s".formatted(path.toAbsolutePath()), e);
                    return null;
                }
            }).build();
            ResourceHandler resourceHandler = new ResourceHandler(resourceManager, exchange -> {
                String url = exchange.getRelativePath();
                if (url.startsWith("/tiles") && (url.endsWith(".png") || url.endsWith(".gz"))) {
                    exchange.setStatusCode(200);
                    return;
                }
                exchange.setStatusCode(404);
                if (UndertowLogger.PREDICATE_LOGGER.isDebugEnabled()) {
                    UndertowLogger.PREDICATE_LOGGER.debugf("Response code set to [%s] for %s.", 404, (Object)exchange);
                }
            });
            LogFilter.HIDE_UNDERTOW_LOGS = true;
            this.server = Undertow.builder().setServerOption(UndertowOptions.ENABLE_HTTP2, true).addHttpListener(Config.HTTPD_PORT, Config.HTTPD_BIND).setHandler(Handlers.path(exchange -> {
                if (exchange.getRelativePath().startsWith("/tiles")) {
                    exchange.getResponseHeaders().put(Headers.CACHE_CONTROL, "max-age=0, must-revalidate, no-cache");
                }
                if (exchange.getRelativePath().endsWith(".gz")) {
                    exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "application/json");
                    exchange.getResponseHeaders().put(Headers.CONTENT_ENCODING, "gzip");
                }
                resourceHandler.handleRequest(exchange);
            }).addPrefixPath("/sse", Handlers.pathTemplate().add("{world}", exchange -> {
                String worldName = exchange.getQueryParameters().get("world").peek();
                if (worldName == null || worldName.isEmpty()) {
                    exchange.getResponseHeaders().put(this.X_ACCEL_BUFFERING, "no");
                    this.liveDataHandler.handle(exchange);
                    return;
                }
                WorldRegistry worldRegistry = Pl3xMap.api().getWorldRegistry();
                World world = (World)worldRegistry.get(worldName);
                if (world == null) {
                    world = worldRegistry.values().stream().filter(World::isEnabled).filter(world1 -> world1.getName().replace(":", "-").equals(worldName)).findFirst().orElse(null);
                }
                if (world == null || !world.isEnabled()) {
                    String listOfValidWorlds = worldRegistry.values().stream().filter(World::isEnabled).map(World::getName).map(s -> s.replace(":", "-")).collect(Collectors.joining(", "));
                    this.handleError(exchange, "Could not find world named '%s'. Available worlds: %s".formatted(worldName, listOfValidWorlds));
                    exchange.endExchange();
                    return;
                }
                if (exchange.isInIoThread()) {
                    exchange.dispatch(world.getServerSentEventHandler().get());
                } else {
                    exchange.getResponseHeaders().put(this.X_ACCEL_BUFFERING, "no");
                    world.getServerSentEventHandler().handle(exchange);
                }
            }))).build();
            this.server.start();
            LogFilter.HIDE_UNDERTOW_LOGS = false;
            Logger.info(Lang.HTTPD_STARTED.replace("<bind>", Config.HTTPD_BIND).replace("<port>", Integer.toString(Config.HTTPD_PORT)));
        }
        catch (Exception e) {
            this.server = null;
            Logger.severe(Lang.HTTPD_START_ERROR, e);
        }
    }

    private void handleError(HttpServerExchange exchange, String errorMessage) {
        exchange.setStatusCode(404);
        exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "application/json");
        exchange.getResponseSender().send("{\"error\": \"" + errorMessage + "\"}");
    }

    public void stopServer() {
        if (!Config.HTTPD_ENABLED) {
            return;
        }
        if (this.server == null) {
            Logger.warn(Lang.HTTPD_STOP_ERROR);
            return;
        }
        LogFilter.HIDE_UNDERTOW_LOGS = true;
        this.liveDataHandler.closeConnections();
        Pl3xMap.api().getWorldRegistry().forEach(world -> world.getServerSentEventHandler().closeConnections());
        this.server.stop();
        LogFilter.HIDE_UNDERTOW_LOGS = false;
        this.server = null;
        Logger.info(Lang.HTTPD_STOPPED);
    }
}

