/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.markers;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.pl3x.map.core.markers.JsonSerializable;
import net.pl3x.map.core.markers.option.Option;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class JsonObjectWrapper {
    private final JsonObject wrapped = new JsonObject();

    public JsonObject getJsonObject() {
        return this.wrapped;
    }

    public void addProperty(String property, @Nullable Enum<?> value) {
        if (value == null) {
            return;
        }
        this.getJsonObject().addProperty(property, (Number)value.ordinal());
    }

    public void addProperty(String property, @Nullable JsonSerializable value) {
        if (value == null) {
            return;
        }
        this.getJsonObject().add(property, value.toJson());
    }

    public void addProperty(String property, @Nullable Option<?> value) {
        if (value == null) {
            return;
        }
        this.getJsonObject().add(property, value.toJson());
    }

    public void addProperty(String property, @Nullable List<? extends JsonSerializable> value) {
        if (value == null) {
            return;
        }
        JsonArray arr = new JsonArray();
        value.forEach(serializable -> {
            if (serializable == null) {
                return;
            }
            arr.add(serializable.toJson());
        });
        this.getJsonObject().add(property, (JsonElement)arr);
    }

    public void addProperty(String property, String value) {
        if (value == null) {
            return;
        }
        this.getJsonObject().addProperty(property, value);
    }

    public void addProperty(String property, Number value) {
        if (value == null) {
            return;
        }
        this.getJsonObject().addProperty(property, value);
    }

    public void addProperty(String property, Boolean value) {
        if (value == null) {
            return;
        }
        this.getJsonObject().addProperty(property, value);
    }

    public void addProperty(String property, Character value) {
        if (value == null) {
            return;
        }
        this.getJsonObject().addProperty(property, value);
    }

    public void add(String property, JsonElement value) {
        if (value == null) {
            return;
        }
        this.getJsonObject().add(property, value);
    }

    public JsonElement remove(String property) {
        return this.getJsonObject().remove(property);
    }

    public Set<Map.Entry<String, JsonElement>> entrySet() {
        return this.getJsonObject().entrySet();
    }

    public Set<String> keySet() {
        return this.getJsonObject().keySet();
    }

    public int size() {
        return this.getJsonObject().size();
    }

    public boolean has(String memberName) {
        return this.getJsonObject().has(memberName);
    }

    public JsonElement get(String memberName) {
        return this.getJsonObject().get(memberName);
    }

    public JsonPrimitive getAsJsonPrimitive(String memberName) {
        return this.getJsonObject().getAsJsonPrimitive(memberName);
    }

    public JsonArray getAsJsonArray(String memberName) {
        return this.getJsonObject().getAsJsonArray(memberName);
    }

    public JsonObject getAsJsonObject(String memberName) {
        return this.getJsonObject().getAsJsonObject(memberName);
    }

    public JsonObject deepCopy() {
        return this.getJsonObject().deepCopy();
    }

    public boolean equals(Object o) {
        JsonObject other;
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() == o.getClass()) {
            other = ((JsonObjectWrapper)o).getJsonObject();
        } else if (JsonObject.class == o.getClass()) {
            other = (JsonObject)o;
        } else {
            return false;
        }
        return this.getJsonObject().equals((Object)other);
    }

    public int hashCode() {
        return this.getJsonObject().hashCode();
    }
}

