/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.markers.area;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import net.pl3x.map.core.markers.area.Area;
import net.pl3x.map.core.util.Mathf;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class Circle
implements Area {
    private final int centerX;
    private final int centerZ;
    private final int radius;

    public Circle(int centerX, int centerZ, int radius) {
        if (radius < 1) {
            throw new IllegalArgumentException("Radius must be positive, but was " + radius);
        }
        this.centerX = centerX;
        this.centerZ = centerZ;
        this.radius = radius;
    }

    public int getCenterX() {
        return this.centerX;
    }

    public int getCenterZ() {
        return this.centerZ;
    }

    public int getRadius() {
        return this.radius;
    }

    @Override
    public boolean containsBlock(int blockX, int blockZ) {
        return Mathf.distanceSquared(blockX, blockZ, this.getCenterX(), this.getCenterZ()) <= Mathf.square(this.getRadius());
    }

    @Override
    public boolean containsChunk(int chunkX, int chunkZ) {
        return this.containsBlock(this.offset(chunkX << 4, this.getCenterX(), 31), this.offset(chunkZ << 4, this.getCenterZ(), 31));
    }

    @Override
    public boolean containsRegion(int regionX, int regionZ) {
        return this.containsBlock(this.offset(regionX << 9, this.getCenterX(), 511), this.offset(regionZ << 9, this.getCenterZ(), 511));
    }

    private int offset(int a2, int b2, int c) {
        return a2 < b2 ? a2 + Math.min(c, b2 - a2) : a2;
    }

    @Override
    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("center-x", this.getCenterX());
        map.put("center-z", this.getCenterZ());
        map.put("radius", this.getRadius());
        return map;
    }

    public static Circle deserialize(Map<String, Object> map) {
        return new Circle((Integer)map.get("center-x"), (Integer)map.get("center-z"), (Integer)map.get("radius"));
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        Circle other = (Circle)o;
        return this.getCenterX() == other.getCenterX() && this.getCenterZ() == other.getCenterZ() && this.getRadius() == other.getRadius();
    }

    public int hashCode() {
        return Objects.hash(this.getCenterX(), this.getCenterZ(), this.getRadius());
    }

    public String toString() {
        return "Circle{centerX=" + this.getCenterX() + ",centerZ=" + this.getCenterZ() + ",radius=" + this.getRadius() + "}";
    }
}

