/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.markers.layer;

import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Supplier;
import net.pl3x.map.core.Keyed;
import net.pl3x.map.core.markers.JsonObjectWrapper;
import net.pl3x.map.core.markers.JsonSerializable;
import net.pl3x.map.core.markers.marker.Marker;
import net.pl3x.map.core.util.Preconditions;
import net.pl3x.map.core.util.TickUtil;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public abstract class Layer
extends Keyed
implements JsonSerializable {
    private Supplier<String> labelSupplier;
    private int updateInterval = TickUtil.toTicks(15);
    private boolean showControls = true;
    private boolean defaultHidden = false;
    private int priority = 99;
    private Integer zIndex = 99;
    private String pane;
    private String css;
    private boolean liveUpdate = false;

    public Layer(String key, Supplier<String> labelSupplier) {
        super(key);
        this.labelSupplier = labelSupplier;
    }

    public String getLabel() {
        return this.labelSupplier.get();
    }

    public Layer setLabel(String label) {
        Preconditions.checkNotNull(label, "Layer label is null");
        this.labelSupplier = () -> label;
        return this;
    }

    public Layer setLabel(Supplier<String> labelSupplier) {
        Preconditions.checkNotNull(labelSupplier, "Layer label supplier is null");
        this.labelSupplier = labelSupplier;
        return this;
    }

    public int getUpdateInterval() {
        return this.getUpdateInterval(false);
    }

    public int getUpdateInterval(boolean ticks) {
        return ticks ? this.updateInterval : (int)TickUtil.toSeconds(this.updateInterval);
    }

    public Layer setUpdateInterval(int updateInterval) {
        this.setUpdateInterval(updateInterval, false);
        return this;
    }

    public Layer setUpdateInterval(int updateInterval, boolean ticks) {
        this.updateInterval = ticks ? updateInterval : TickUtil.toTicks(updateInterval);
        return this;
    }

    public boolean shouldShowControls() {
        return this.showControls;
    }

    public Layer setShowControls(boolean showControls) {
        this.showControls = showControls;
        return this;
    }

    public boolean isDefaultHidden() {
        return this.defaultHidden;
    }

    public Layer setDefaultHidden(boolean defaultHidden) {
        this.defaultHidden = defaultHidden;
        return this;
    }

    public int getPriority() {
        return this.priority;
    }

    public Layer setPriority(int priority) {
        this.priority = priority;
        return this;
    }

    public @Nullable Integer getZIndex() {
        return this.zIndex == null ? this.getPriority() : this.zIndex.intValue();
    }

    public Layer setZIndex(@Nullable Integer zIndex) {
        this.zIndex = zIndex;
        return this;
    }

    public @Nullable String getPane() {
        return this.pane;
    }

    public Layer setPane(@Nullable String pane) {
        this.pane = pane;
        return this;
    }

    public @Nullable String getCss() {
        return this.css;
    }

    public Layer setCss(@Nullable String css) {
        this.css = css;
        return this;
    }

    public @Nullable boolean isLiveUpdate() {
        return this.liveUpdate;
    }

    public Layer setLiveUpdate(@Nullable boolean liveUpdate) {
        this.liveUpdate = liveUpdate;
        return this;
    }

    public abstract Collection<Marker<?>> getMarkers();

    public JsonObject toJson() {
        JsonObjectWrapper wrapper = new JsonObjectWrapper();
        wrapper.addProperty("key", this.getKey());
        wrapper.addProperty("label", this.getLabel());
        wrapper.addProperty("updateInterval", this.getUpdateInterval());
        wrapper.addProperty("showControls", this.shouldShowControls());
        wrapper.addProperty("defaultHidden", this.isDefaultHidden());
        wrapper.addProperty("priority", this.getPriority());
        wrapper.addProperty("zIndex", this.getZIndex());
        wrapper.addProperty("pane", this.getPane());
        wrapper.addProperty("css", this.getCss());
        return wrapper.getJsonObject();
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        Layer other = (Layer)o;
        return this.getKey().equals(other.getKey()) && this.getLabel().equals(other.getLabel()) && this.getUpdateInterval() == other.getUpdateInterval() && this.shouldShowControls() == other.shouldShowControls() && this.isDefaultHidden() == other.isDefaultHidden() && this.getPriority() == other.getPriority() && Objects.equals(this.getZIndex(), other.getZIndex()) && Objects.equals(this.getPane(), other.getPane()) && Objects.equals(this.getCss(), other.getCss());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getKey(), this.getLabel(), this.getUpdateInterval(), this.shouldShowControls(), this.isDefaultHidden(), this.getPriority(), this.getZIndex(), this.getPane(), this.getCss());
    }

    @Override
    public String toString() {
        return "Layer{key=" + this.getKey() + ",label=" + this.getLabel() + ",updateInterval=" + this.getUpdateInterval() + ",showControls=" + this.shouldShowControls() + ",defaultHidden=" + this.isDefaultHidden() + ",priority=" + this.getPriority() + ",zIndex=" + this.getZIndex() + ",pane=" + this.getPane() + ",css=" + this.getCss() + "}";
    }
}

