/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.markers.layer;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.Supplier;
import javax.imageio.ImageIO;
import net.pl3x.map.core.Pl3xMap;
import net.pl3x.map.core.configuration.Lang;
import net.pl3x.map.core.configuration.PlayersLayerConfig;
import net.pl3x.map.core.image.IconImage;
import net.pl3x.map.core.markers.Point;
import net.pl3x.map.core.markers.layer.WorldLayer;
import net.pl3x.map.core.markers.marker.Icon;
import net.pl3x.map.core.markers.marker.Marker;
import net.pl3x.map.core.markers.option.Options;
import net.pl3x.map.core.markers.option.Tooltip;
import net.pl3x.map.core.player.Player;
import net.pl3x.map.core.util.FileUtil;
import net.pl3x.map.core.world.World;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class PlayersLayer
extends WorldLayer {
    public static final String KEY = "pl3xmap_players";
    private final String icon = PlayersLayerConfig.ICON;

    public PlayersLayer(World world) {
        this(KEY, world, () -> Lang.UI_LAYER_PLAYERS);
        this.setUpdateInterval(PlayersLayerConfig.UPDATE_INTERVAL);
        this.setLiveUpdate(PlayersLayerConfig.LIVE_UPDATE);
        this.setShowControls(PlayersLayerConfig.SHOW_CONTROLS);
        this.setDefaultHidden(PlayersLayerConfig.DEFAULT_HIDDEN);
        this.setPriority(PlayersLayerConfig.PRIORITY);
        this.setZIndex(PlayersLayerConfig.Z_INDEX);
        this.setPane(PlayersLayerConfig.PANE);
        this.setCss(PlayersLayerConfig.CSS);
    }

    public PlayersLayer(String key, World world, Supplier<String> labelSupplier) {
        super(key, world, labelSupplier);
        Path player = FileUtil.getWebDir().resolve("images/icon/" + this.icon + ".png");
        try {
            IconImage playerImage = new IconImage(this.icon, ImageIO.read(player.toFile()), "png");
            Pl3xMap.api().getIconRegistry().register(playerImage);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Collection<Marker<?>> getMarkers() {
        HashSet icons = new HashSet();
        this.getWorld().getPlayers().forEach(player -> {
            if (player.isHidden()) {
                return;
            }
            if (player.isNPC()) {
                return;
            }
            if (PlayersLayerConfig.HIDE_INVISIBLE && player.isInvisible()) {
                return;
            }
            if (PlayersLayerConfig.HIDE_SPECTATORS && player.isSpectator()) {
                return;
            }
            icons.add(this.createIcon((Player)player));
        });
        return icons;
    }

    private Icon createIcon(Player player) {
        Icon icon = (Icon)Marker.icon(player.getUUID().toString(), player.getPosition(), this.icon, 16.0).setRotationAngle(Double.valueOf(player.getYaw())).setRotationOrigin("center").setPane("players");
        String tooltip = PlayersLayerConfig.TOOLTIP;
        if (tooltip == null || tooltip.isBlank()) {
            return icon;
        }
        return (Icon)icon.setOptions(Options.builder().tooltipContent(tooltip.replace("<uuid>", player.getUUID().toString()).replace("<name>", player.getName()).replace("<decoratedName>", player.getDecoratedName()).replace("<health>", Integer.toString(player.getHealth())).replace("<armor>", Integer.toString(player.getArmorPoints()))).tooltipPane(PlayersLayerConfig.PANE).tooltipDirection(Tooltip.Direction.RIGHT).tooltipPermanent(true).tooltipOffset(Point.of(5, 0)).tooltipOpacity(1.0).build());
    }
}

